/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.management;

import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessError;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceExecutionException;
import org.kie.kogito.process.Processes;

@Path(value="/management/process")
public class ProcessInstanceManagementResource {
    @Inject
    Processes processes;

    @GET
    @Path(value="{processId}/instances/{processInstanceId}/error")
    @Produces(value={"application/json"})
    public Response getInstanceInError(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId) {
        return this.executeOnInstanceInError(processId, processInstanceId, processInstance -> {
            ProcessError error = (ProcessError)processInstance.error().get();
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("id", processInstance.id());
            data.put("failedNodeId", error.failedNodeId());
            data.put("message", error.errorMessage());
            return Response.status((Response.Status)Response.Status.OK).entity(data).build();
        });
    }

    @POST
    @Path(value="{processId}/instances/{processInstanceId}/retrigger")
    @Produces(value={"application/json"})
    public Response retriggerInstanceInError(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId) {
        return this.executeOnInstanceInError(processId, processInstanceId, processInstance -> {
            ((ProcessError)processInstance.error().get()).retrigger();
            if (processInstance.status() == 5) {
                throw new ProcessInstanceExecutionException(processInstance.id(), ((ProcessError)processInstance.error().get()).failedNodeId(), ((ProcessError)processInstance.error().get()).errorMessage());
            }
            return Response.status((Response.Status)Response.Status.OK).entity(processInstance.variables()).build();
        });
    }

    @POST
    @Path(value="{processId}/instances/{processInstanceId}/skip")
    @Produces(value={"application/json"})
    public Response skipInstanceInError(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId) {
        return this.executeOnInstanceInError(processId, processInstanceId, processInstance -> {
            ((ProcessError)processInstance.error().get()).skip();
            if (processInstance.status() == 5) {
                throw new ProcessInstanceExecutionException(processInstance.id(), ((ProcessError)processInstance.error().get()).failedNodeId(), ((ProcessError)processInstance.error().get()).errorMessage());
            }
            return Response.status((Response.Status)Response.Status.OK).entity(processInstance.variables()).build();
        });
    }

    protected Response executeOnInstanceInError(String processId, String processInstanceId, Function<ProcessInstance<?>, Response> supplier) {
        if (processId == null || processInstanceId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Process id and Process instance id must be given").build();
        }
        Process process = this.processes.processById(processId);
        if (process == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Process with id " + processId + " not found")).build();
        }
        Optional processInstanceFound = process.instances().findById(processInstanceId);
        if (processInstanceFound.isPresent()) {
            ProcessInstance processInstance = (ProcessInstance)processInstanceFound.get();
            if (processInstance.error().isPresent()) {
                return supplier.apply(processInstance);
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Process instance with id " + processInstanceId + " is not in error state")).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Process instance with id " + processInstanceId + " not found")).build();
    }
}

