/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serialization.process.impl.marshallers;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import java.time.Instant;
import java.util.Date;
import org.kie.kogito.serialization.process.ObjectMarshallerStrategy;
import org.kie.kogito.serialization.process.ProcessInstanceMarshallerException;

public class ProtobufDateMarshallerStrategy
implements ObjectMarshallerStrategy {
    @Override
    public boolean acceptForMarshalling(Object value) {
        return Date.class.equals(value.getClass());
    }

    @Override
    public boolean acceptForUnmarshalling(Object value) {
        return ((Any)value).is(Timestamp.class);
    }

    @Override
    public Object marshall(Object unmarshalled) {
        Timestamp timestamp = Timestamps.fromMillis((long)((Date)unmarshalled).getTime());
        return Any.pack((Message)timestamp);
    }

    @Override
    public Object unmarshall(Object marshalled) {
        try {
            Any data = (Any)marshalled;
            Timestamp storedValue = (Timestamp)data.unpack(Timestamp.class);
            return new Date(Instant.ofEpochSecond(storedValue.getSeconds(), storedValue.getNanos()).toEpochMilli());
        }
        catch (InvalidProtocolBufferException e1) {
            throw new ProcessInstanceMarshallerException("Error trying to unmarshalling a date value", e1);
        }
    }
}

