/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serialization.process.impl.marshallers;

import com.google.protobuf.Any;
import com.google.protobuf.FloatValue;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import org.kie.kogito.serialization.process.ObjectMarshallerStrategy;
import org.kie.kogito.serialization.process.ProcessInstanceMarshallerException;

public class ProtobufFloatMarshallerStrategy
implements ObjectMarshallerStrategy {
    @Override
    public boolean acceptForMarshalling(Object value) {
        return Float.class.equals(value.getClass());
    }

    @Override
    public boolean acceptForUnmarshalling(Object value) {
        return ((Any)value).is(FloatValue.class);
    }

    @Override
    public Object marshall(Object unmarshalled) {
        return Any.pack((Message)FloatValue.of((float)((Float)unmarshalled).floatValue()));
    }

    @Override
    public Object unmarshall(Object marshalled) {
        try {
            Any data = (Any)marshalled;
            FloatValue storedValue = (FloatValue)data.unpack(FloatValue.class);
            return Float.valueOf(storedValue.getValue());
        }
        catch (InvalidProtocolBufferException e1) {
            throw new ProcessInstanceMarshallerException("Error trying to unmarshalling a float value", e1);
        }
    }
}

