/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serialization.process.impl;

import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.context.exclusive.ExclusiveGroupInstance;
import org.jbpm.process.instance.context.swimlane.SwimlaneContextInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.humantask.Reassignment;
import org.jbpm.workflow.core.node.AsyncEventNodeInstance;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.CompositeContextNodeInstance;
import org.jbpm.workflow.instance.node.DynamicNodeInstance;
import org.jbpm.workflow.instance.node.EventNodeInstance;
import org.jbpm.workflow.instance.node.EventSubProcessNodeInstance;
import org.jbpm.workflow.instance.node.ForEachNodeInstance;
import org.jbpm.workflow.instance.node.HumanTaskNodeInstance;
import org.jbpm.workflow.instance.node.JoinInstance;
import org.jbpm.workflow.instance.node.LambdaSubProcessNodeInstance;
import org.jbpm.workflow.instance.node.MilestoneNodeInstance;
import org.jbpm.workflow.instance.node.RuleSetNodeInstance;
import org.jbpm.workflow.instance.node.StateNodeInstance;
import org.jbpm.workflow.instance.node.SubProcessNodeInstance;
import org.jbpm.workflow.instance.node.TimerNodeInstance;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.process.workitem.Attachment;
import org.kie.kogito.process.workitem.Comment;
import org.kie.kogito.process.workitem.HumanTaskWorkItem;
import org.kie.kogito.process.workitems.InternalKogitoWorkItem;
import org.kie.kogito.serialization.process.MarshallerContextName;
import org.kie.kogito.serialization.process.MarshallerWriterContext;
import org.kie.kogito.serialization.process.impl.ProtobufVariableWriter;
import org.kie.kogito.serialization.process.protobuf.KogitoNodeInstanceContentsProtobuf;
import org.kie.kogito.serialization.process.protobuf.KogitoProcessInstanceProtobuf;
import org.kie.kogito.serialization.process.protobuf.KogitoTypesProtobuf;
import org.kie.kogito.serialization.process.protobuf.KogitoWorkItemsProtobuf;
import org.kie.kogito.serialization.process.protobuf.ProtobufTypeRegistryFactory;

public class ProtobufProcessInstanceWriter {
    private MarshallerWriterContext context;
    private ProtobufVariableWriter varWriter;

    public ProtobufProcessInstanceWriter(MarshallerWriterContext context) {
        this.context = context;
        this.varWriter = new ProtobufVariableWriter(context);
    }

    public void writeProcessInstance(WorkflowProcessInstanceImpl workFlow, OutputStream os) throws IOException {
        KogitoProcessInstanceProtobuf.ProcessInstance.Builder instance = KogitoProcessInstanceProtobuf.ProcessInstance.newBuilder().setId(workFlow.getStringId()).setProcessId(workFlow.getProcessId()).setState(workFlow.getState()).setProcessType(workFlow.getProcess().getType()).setSignalCompletion(workFlow.isSignalCompletion());
        if (workFlow.getStartDate() != null) {
            instance.setStartDate(workFlow.getStartDate().getTime());
        }
        if (workFlow.getDescription() != null) {
            instance.setDescription(workFlow.getDescription());
        }
        if (workFlow.getDeploymentId() != null) {
            instance.setDeploymentId(workFlow.getDeploymentId());
        }
        instance.addAllCompletedNodeIds(workFlow.getCompletedNodeIds());
        if (workFlow.getCorrelationKey() != null) {
            instance.setBusinessKey(workFlow.getCorrelationKey());
        }
        instance.setSla(this.buildSLAContext(workFlow.getSlaCompliance(), workFlow.getSlaDueDate(), workFlow.getSlaTimerId()));
        if (workFlow.getParentProcessInstanceStringId() != null) {
            instance.setParentProcessInstanceId(workFlow.getParentProcessInstanceStringId());
        }
        if (workFlow.getRootProcessInstanceId() != null) {
            instance.setRootProcessInstanceId(workFlow.getRootProcessInstanceId());
        }
        if (workFlow.getRootProcessId() != null) {
            instance.setRootProcessId(workFlow.getRootProcessId());
        }
        if (workFlow.getNodeIdInError() != null) {
            instance.setErrorNodeId(workFlow.getNodeIdInError());
        }
        if (workFlow.getErrorMessage() != null) {
            instance.setErrorMessage(workFlow.getErrorMessage());
        }
        if (workFlow.getReferenceId() != null) {
            instance.setReferenceId(workFlow.getReferenceId());
        }
        instance.addAllSwimlaneContext(this.buildSwimlaneContexts((SwimlaneContextInstance)workFlow.getContextInstance("SwimlaneScope")));
        ArrayList<NodeInstance> nodeInstances = new ArrayList<NodeInstance>(workFlow.getNodeInstances());
        List exclusiveGroupInstances = workFlow.getContextInstances("ExclusiveGroup");
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)workFlow.getContextInstance("VariableScope");
        ArrayList<Map.Entry<String, Object>> variables = new ArrayList<Map.Entry<String, Object>>(variableScopeInstance.getVariables().entrySet());
        ArrayList<Map.Entry<String, Integer>> iterationlevels = new ArrayList<Map.Entry<String, Integer>>(workFlow.getIterationLevels().entrySet());
        instance.setContext(this.buildWorkflowContext(nodeInstances, exclusiveGroupInstances, variables, iterationlevels));
        KogitoProcessInstanceProtobuf.ProcessInstance piProtobuf = instance.build();
        String format = this.context.get(MarshallerContextName.MARSHALLER_FORMAT);
        if (format != null && "json".equals(format)) {
            os.write(JsonFormat.printer().usingTypeRegistry(ProtobufTypeRegistryFactory.protobufTypeRegistryFactoryInstance().create()).print((MessageOrBuilder)piProtobuf).getBytes());
        } else {
            piProtobuf.writeTo(os);
        }
    }

    private KogitoTypesProtobuf.SLAContext buildSLAContext(int slaCompliance, Date slaDueDate, String slaTimerId) {
        KogitoTypesProtobuf.SLAContext.Builder slaContextBuilder = KogitoTypesProtobuf.SLAContext.newBuilder().setSlaCompliance(slaCompliance);
        if (slaDueDate != null) {
            slaContextBuilder.setSlaDueDate(slaDueDate.getTime());
        }
        if (slaTimerId != null) {
            slaContextBuilder.setSlaTimerId(slaTimerId);
        }
        return slaContextBuilder.build();
    }

    private List<KogitoTypesProtobuf.SwimlaneContext> buildSwimlaneContexts(SwimlaneContextInstance swimlaneContextInstance) {
        if (swimlaneContextInstance == null) {
            return Collections.emptyList();
        }
        ArrayList<KogitoTypesProtobuf.SwimlaneContext> contexts = new ArrayList<KogitoTypesProtobuf.SwimlaneContext>();
        Map swimlaneActors = swimlaneContextInstance.getSwimlaneActors();
        for (Map.Entry entry : swimlaneActors.entrySet()) {
            contexts.add(KogitoTypesProtobuf.SwimlaneContext.newBuilder().setSwimlane((String)entry.getKey()).setActorId((String)entry.getValue()).build());
        }
        return contexts;
    }

    private KogitoTypesProtobuf.WorkflowContext buildWorkflowContext(List<NodeInstance> nodeInstances, List<ContextInstance> exclusiveGroupInstances, List<Map.Entry<String, Object>> variables, List<Map.Entry<String, Integer>> iterationlevels) {
        KogitoTypesProtobuf.WorkflowContext.Builder workflowContextBuilder = KogitoTypesProtobuf.WorkflowContext.newBuilder();
        workflowContextBuilder.addAllNodeInstance(this.buildNodeInstances(nodeInstances));
        workflowContextBuilder.addAllExclusiveGroup(this.buildGroups(exclusiveGroupInstances));
        workflowContextBuilder.addAllVariable(this.varWriter.buildVariables(variables));
        workflowContextBuilder.addAllIterationLevels(this.buildIterationLevels(iterationlevels));
        return workflowContextBuilder.build();
    }

    private List<KogitoTypesProtobuf.NodeInstance> buildNodeInstances(List<NodeInstance> nodeInstances) {
        Comparator comparator = (o1, o2) -> ((KogitoNodeInstance)o1).getStringId().compareTo(((KogitoNodeInstance)o2).getStringId());
        Collections.sort(nodeInstances, comparator);
        ArrayList<KogitoTypesProtobuf.NodeInstance> nodeInstancesProtobuf = new ArrayList<KogitoTypesProtobuf.NodeInstance>();
        for (NodeInstance nodeInstance : nodeInstances) {
            KogitoTypesProtobuf.NodeInstance.Builder node = KogitoTypesProtobuf.NodeInstance.newBuilder().setId(((KogitoNodeInstance)nodeInstance).getStringId()).setNodeId(nodeInstance.getNodeId()).setLevel(((org.jbpm.workflow.instance.NodeInstance)nodeInstance).getLevel());
            Date triggerDate = ((org.jbpm.workflow.instance.NodeInstance)nodeInstance).getTriggerTime();
            if (triggerDate != null) {
                node.setTriggerDate(triggerDate.getTime());
            }
            node.setSla(this.buildSLAContext(((org.jbpm.workflow.instance.NodeInstance)nodeInstance).getSlaCompliance(), ((org.jbpm.workflow.instance.NodeInstance)nodeInstance).getSlaDueDate(), ((org.jbpm.workflow.instance.NodeInstance)nodeInstance).getSlaTimerId()));
            node.setContent(this.buildNodeInstanceContent(nodeInstance));
            nodeInstancesProtobuf.add(node.build());
        }
        return nodeInstancesProtobuf;
    }

    private Any buildNodeInstanceContent(NodeInstance nodeInstance) {
        if (nodeInstance instanceof RuleSetNodeInstance) {
            return this.buildRuleSetNodeInstance((RuleSetNodeInstance)nodeInstance);
        }
        if (nodeInstance instanceof ForEachNodeInstance) {
            return this.buildForEachNodeInstance((ForEachNodeInstance)nodeInstance);
        }
        if (nodeInstance instanceof LambdaSubProcessNodeInstance) {
            return this.buildLambdaSubProcessNodeInstance((LambdaSubProcessNodeInstance)nodeInstance);
        }
        if (nodeInstance instanceof SubProcessNodeInstance) {
            return this.buildSubProcessNodeInstance((SubProcessNodeInstance)nodeInstance);
        }
        if (nodeInstance instanceof StateNodeInstance) {
            return this.buildStateNodeInstance((StateNodeInstance)nodeInstance);
        }
        if (nodeInstance instanceof JoinInstance) {
            return this.buildJoinInstance((JoinInstance)nodeInstance);
        }
        if (nodeInstance instanceof TimerNodeInstance) {
            return this.buildTimerNodeInstance((TimerNodeInstance)nodeInstance);
        }
        if (nodeInstance instanceof AsyncEventNodeInstance) {
            return this.buildAsyncEventNodeInstance((AsyncEventNodeInstance)nodeInstance);
        }
        if (nodeInstance instanceof EventNodeInstance) {
            return this.buildEventNodeInstance();
        }
        if (nodeInstance instanceof MilestoneNodeInstance) {
            return this.buildMilestoneNodeInstance((MilestoneNodeInstance)nodeInstance);
        }
        if (nodeInstance instanceof DynamicNodeInstance) {
            return this.buildDynamicNodeInstance((DynamicNodeInstance)nodeInstance);
        }
        if (nodeInstance instanceof EventSubProcessNodeInstance) {
            return this.buildEventSubProcessNodeInstance((EventSubProcessNodeInstance)nodeInstance);
        }
        if (nodeInstance instanceof CompositeContextNodeInstance) {
            return this.buildCompositeContextNodeInstance((CompositeContextNodeInstance)nodeInstance);
        }
        if (nodeInstance instanceof HumanTaskNodeInstance) {
            return this.buildHumanTaskNodeInstance((HumanTaskNodeInstance)nodeInstance);
        }
        if (nodeInstance instanceof WorkItemNodeInstance) {
            return this.buildWorkItemNodeInstance((WorkItemNodeInstance)nodeInstance);
        }
        throw new IllegalArgumentException("Unknown node instance type: " + nodeInstance);
    }

    private Any buildAsyncEventNodeInstance(AsyncEventNodeInstance nodeInstance) {
        KogitoNodeInstanceContentsProtobuf.AsyncEventNodeInstanceContent.Builder builder = KogitoNodeInstanceContentsProtobuf.AsyncEventNodeInstanceContent.newBuilder();
        if (nodeInstance.getJobId() != null) {
            builder.setJobId(nodeInstance.getJobId());
        }
        return Any.pack((Message)builder.build());
    }

    private Any buildRuleSetNodeInstance(RuleSetNodeInstance nodeInstance) {
        KogitoNodeInstanceContentsProtobuf.RuleSetNodeInstanceContent.Builder ruleSet = KogitoNodeInstanceContentsProtobuf.RuleSetNodeInstanceContent.newBuilder();
        ruleSet.setRuleFlowGroup(nodeInstance.getRuleFlowGroup());
        ruleSet.addAllTimerInstanceId(nodeInstance.getTimerInstances());
        return Any.pack((Message)ruleSet.build());
    }

    private Any buildForEachNodeInstance(ForEachNodeInstance nodeInstance) {
        KogitoNodeInstanceContentsProtobuf.ForEachNodeInstanceContent.Builder foreachBuilder = KogitoNodeInstanceContentsProtobuf.ForEachNodeInstanceContent.newBuilder();
        List timerInstances = nodeInstance.getTimerInstances();
        if (timerInstances != null) {
            foreachBuilder.addAllTimerInstanceId(timerInstances);
        }
        List<NodeInstance> nodeInstances = nodeInstance.getNodeInstances().stream().filter(CompositeContextNodeInstance.class::isInstance).collect(Collectors.toList());
        List exclusiveGroupInstances = nodeInstance.getContextInstances("ExclusiveGroup");
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)nodeInstance.getContextInstance("VariableScope");
        ArrayList<Map.Entry<String, Object>> variables = variableScopeInstance != null ? new ArrayList<Map.Entry<String, Object>>(variableScopeInstance.getVariables().entrySet()) : Collections.emptyList();
        ArrayList<Map.Entry<String, Integer>> iterationlevels = new ArrayList<Map.Entry<String, Integer>>(nodeInstance.getIterationLevels().entrySet());
        foreachBuilder.setContext(this.buildWorkflowContext(nodeInstances, exclusiveGroupInstances, variables, iterationlevels));
        foreachBuilder.setTotalInstances(nodeInstance.getTotalInstances()).setExecutedInstances(nodeInstance.getExecutedInstances()).setHasAsyncInstances(nodeInstance.getHasAsyncInstances());
        return Any.pack((Message)foreachBuilder.build());
    }

    private Any buildLambdaSubProcessNodeInstance(LambdaSubProcessNodeInstance nodeInstance) {
        KogitoNodeInstanceContentsProtobuf.LambdaSubProcessNodeInstanceContent.Builder builder = KogitoNodeInstanceContentsProtobuf.LambdaSubProcessNodeInstanceContent.newBuilder();
        builder.setProcessInstanceId(nodeInstance.getProcessInstanceId());
        List timerInstances = nodeInstance.getTimerInstances();
        if (timerInstances != null) {
            builder.addAllTimerInstanceId(timerInstances);
        }
        return Any.pack((Message)builder.build());
    }

    private Any buildSubProcessNodeInstance(SubProcessNodeInstance nodeInstance) {
        KogitoNodeInstanceContentsProtobuf.SubProcessNodeInstanceContent.Builder builder = KogitoNodeInstanceContentsProtobuf.SubProcessNodeInstanceContent.newBuilder();
        builder.setProcessInstanceId(nodeInstance.getProcessInstanceId());
        List timerInstances = nodeInstance.getTimerInstances();
        if (timerInstances != null) {
            builder.addAllTimerInstanceId(timerInstances);
        }
        return Any.pack((Message)builder.build());
    }

    private Any buildStateNodeInstance(StateNodeInstance nodeInstance) {
        KogitoNodeInstanceContentsProtobuf.StateNodeInstanceContent.Builder builder = KogitoNodeInstanceContentsProtobuf.StateNodeInstanceContent.newBuilder();
        List timerInstances = nodeInstance.getTimerInstances();
        if (timerInstances != null) {
            builder.addAllTimerInstanceId(timerInstances);
        }
        return Any.pack((Message)builder.build());
    }

    private Any buildJoinInstance(JoinInstance nodeInstance) {
        KogitoNodeInstanceContentsProtobuf.JoinNodeInstanceContent.Builder joinBuilder = KogitoNodeInstanceContentsProtobuf.JoinNodeInstanceContent.newBuilder();
        Map triggers = nodeInstance.getTriggers();
        ArrayList keys = new ArrayList(triggers.keySet());
        Comparator comparator = (o1, o2) -> o1.compareTo((Long)o2);
        Collections.sort(keys, comparator);
        for (Long key : keys) {
            joinBuilder.addTrigger(KogitoNodeInstanceContentsProtobuf.JoinNodeInstanceContent.JoinTrigger.newBuilder().setNodeId(key).setCounter((Integer)triggers.get(key)).build());
        }
        return Any.pack((Message)joinBuilder.build());
    }

    private Any buildTimerNodeInstance(TimerNodeInstance nodeInstance) {
        return Any.pack((Message)KogitoNodeInstanceContentsProtobuf.TimerNodeInstanceContent.newBuilder().setTimerId(nodeInstance.getTimerId()).build());
    }

    private Any buildEventNodeInstance() {
        return Any.pack((Message)KogitoNodeInstanceContentsProtobuf.EventNodeInstanceContent.newBuilder().build());
    }

    private Any buildMilestoneNodeInstance(MilestoneNodeInstance nodeInstance) {
        KogitoNodeInstanceContentsProtobuf.MilestoneNodeInstanceContent.Builder builder = KogitoNodeInstanceContentsProtobuf.MilestoneNodeInstanceContent.newBuilder();
        List timerInstances = nodeInstance.getTimerInstances();
        if (timerInstances != null) {
            builder.addAllTimerInstanceId(timerInstances);
        }
        return Any.pack((Message)builder.build());
    }

    private Any buildDynamicNodeInstance(DynamicNodeInstance nodeInstance) {
        KogitoNodeInstanceContentsProtobuf.DynamicNodeInstanceContent.Builder builder = KogitoNodeInstanceContentsProtobuf.DynamicNodeInstanceContent.newBuilder();
        List timerInstances = nodeInstance.getTimerInstances();
        if (timerInstances != null) {
            builder.addAllTimerInstanceId(timerInstances);
        }
        builder.setContext(this.buildWorkflowContext((CompositeContextNodeInstance)nodeInstance));
        return Any.pack((Message)builder.build());
    }

    private Any buildEventSubProcessNodeInstance(EventSubProcessNodeInstance nodeInstance) {
        KogitoNodeInstanceContentsProtobuf.EventSubProcessNodeInstanceContent.Builder builder = KogitoNodeInstanceContentsProtobuf.EventSubProcessNodeInstanceContent.newBuilder();
        List timerInstances = nodeInstance.getTimerInstances();
        if (timerInstances != null) {
            builder.addAllTimerInstanceId(timerInstances);
        }
        builder.setContext(this.buildWorkflowContext((CompositeContextNodeInstance)nodeInstance));
        return Any.pack((Message)builder.build());
    }

    private Any buildCompositeContextNodeInstance(CompositeContextNodeInstance nodeInstance) {
        KogitoNodeInstanceContentsProtobuf.CompositeContextNodeInstanceContent.Builder builder = KogitoNodeInstanceContentsProtobuf.CompositeContextNodeInstanceContent.newBuilder();
        List timerInstances = nodeInstance.getTimerInstances();
        if (timerInstances != null) {
            builder.addAllTimerInstanceId(timerInstances);
        }
        builder.setContext(this.buildWorkflowContext(nodeInstance));
        return Any.pack((Message)builder.build());
    }

    private KogitoTypesProtobuf.WorkflowContext buildWorkflowContext(CompositeContextNodeInstance nodeInstance) {
        ArrayList<NodeInstance> nodeInstances = new ArrayList<NodeInstance>(nodeInstance.getNodeInstances());
        List exclusiveGroupInstances = nodeInstance.getContextInstances("ExclusiveGroup");
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)nodeInstance.getContextInstance("VariableScope");
        ArrayList<Map.Entry<String, Object>> variables = variableScopeInstance != null ? new ArrayList<Map.Entry<String, Object>>(variableScopeInstance.getVariables().entrySet()) : Collections.emptyList();
        ArrayList<Map.Entry<String, Integer>> iterationlevels = new ArrayList<Map.Entry<String, Integer>>(nodeInstance.getIterationLevels().entrySet());
        return this.buildWorkflowContext(nodeInstances, exclusiveGroupInstances, variables, iterationlevels);
    }

    private Any buildWorkItemNodeInstance(WorkItemNodeInstance nodeInstance) {
        return Any.pack((Message)this.buildWorkItemNodeInstanceBuilder(nodeInstance).build());
    }

    private KogitoNodeInstanceContentsProtobuf.WorkItemNodeInstanceContent.Builder buildWorkItemNodeInstanceBuilder(WorkItemNodeInstance nodeInstance) {
        KogitoNodeInstanceContentsProtobuf.WorkItemNodeInstanceContent.Builder builder = KogitoNodeInstanceContentsProtobuf.WorkItemNodeInstanceContent.newBuilder();
        List timerInstances = nodeInstance.getTimerInstances();
        if (timerInstances != null) {
            builder.addAllTimerInstanceId(timerInstances);
        }
        if (nodeInstance.getExceptionHandlingProcessInstanceId() != null) {
            builder.setErrorHandlingProcessInstanceId(nodeInstance.getExceptionHandlingProcessInstanceId());
        }
        InternalKogitoWorkItem workItem = nodeInstance.getWorkItem();
        builder.setWorkItemId(nodeInstance.getWorkItemId()).setName(workItem.getName()).setState(workItem.getState()).setPhaseId(workItem.getPhaseId()).setPhaseStatus(workItem.getPhaseStatus()).setStartDate(workItem.getStartDate().getTime()).addAllVariable(this.varWriter.buildVariables(new ArrayList<Map.Entry<String, Object>>(workItem.getParameters().entrySet()))).addAllResult(this.varWriter.buildVariables(new ArrayList<Map.Entry<String, Object>>(workItem.getResults().entrySet())));
        if (workItem.getCompleteDate() != null) {
            builder.setCompleteDate(workItem.getCompleteDate().getTime());
        }
        return builder;
    }

    private Any buildHumanTaskNodeInstance(HumanTaskNodeInstance nodeInstance) {
        KogitoNodeInstanceContentsProtobuf.WorkItemNodeInstanceContent.Builder builder = this.buildWorkItemNodeInstanceBuilder((WorkItemNodeInstance)nodeInstance);
        builder.setWorkItemData(Any.pack((Message)this.buildHumanTaskWorkItemData(nodeInstance, (HumanTaskWorkItem)nodeInstance.getWorkItem())));
        return Any.pack((Message)builder.build());
    }

    private List<KogitoTypesProtobuf.NodeInstanceGroup> buildGroups(List<ContextInstance> exclusiveGroupInstances) {
        if (exclusiveGroupInstances == null) {
            return Collections.emptyList();
        }
        ArrayList<KogitoTypesProtobuf.NodeInstanceGroup> groupProtobuf = new ArrayList<KogitoTypesProtobuf.NodeInstanceGroup>();
        for (ContextInstance contextInstance : exclusiveGroupInstances) {
            KogitoTypesProtobuf.NodeInstanceGroup.Builder exclusiveNodeInstanceGroup = KogitoTypesProtobuf.NodeInstanceGroup.newBuilder();
            ExclusiveGroupInstance exclusiveGroupInstance = (ExclusiveGroupInstance)contextInstance;
            Collection groupNodeInstances = exclusiveGroupInstance.getNodeInstances();
            for (KogitoNodeInstance nodeInstance : groupNodeInstances) {
                exclusiveNodeInstanceGroup.addGroupNodeInstanceId(nodeInstance.getStringId());
            }
            groupProtobuf.add(exclusiveNodeInstanceGroup.build());
        }
        return groupProtobuf;
    }

    private List<KogitoTypesProtobuf.IterationLevel> buildIterationLevels(List<Map.Entry<String, Integer>> iterationlevels) {
        Comparator comparator = (o1, o2) -> ((String)o1.getKey()).compareTo((String)o2.getKey());
        Collections.sort(iterationlevels, comparator);
        ArrayList<KogitoTypesProtobuf.IterationLevel> levelsProtobuf = new ArrayList<KogitoTypesProtobuf.IterationLevel>();
        for (Map.Entry<String, Integer> level : iterationlevels) {
            if (level.getValue() == null) continue;
            KogitoTypesProtobuf.IterationLevel levelProtobuf = KogitoTypesProtobuf.IterationLevel.newBuilder().setId(level.getKey()).setLevel(level.getValue()).build();
            levelsProtobuf.add(levelProtobuf);
        }
        return levelsProtobuf;
    }

    private KogitoWorkItemsProtobuf.HumanTaskWorkItemData buildHumanTaskWorkItemData(HumanTaskNodeInstance nodeInstance, HumanTaskWorkItem workItem) {
        KogitoWorkItemsProtobuf.HumanTaskWorkItemData.Builder builder = KogitoWorkItemsProtobuf.HumanTaskWorkItemData.newBuilder();
        if (workItem.getTaskPriority() != null) {
            builder.setTaskPriority(workItem.getTaskPriority());
        }
        if (workItem.getReferenceName() != null) {
            builder.setTaskReferenceName(workItem.getReferenceName());
        }
        if (workItem.getTaskDescription() != null) {
            builder.setTaskDescription(workItem.getTaskDescription());
        }
        if (workItem.getActualOwner() != null) {
            builder.setActualOwner(workItem.getActualOwner());
        }
        if (workItem.getTaskName() != null) {
            builder.setTaskName(workItem.getTaskName());
        }
        if (workItem.getPotentialUsers() != null) {
            builder.addAllPotUsers(workItem.getPotentialUsers());
        }
        if (workItem.getPotentialGroups() != null) {
            builder.addAllPotGroups(workItem.getPotentialGroups());
        }
        if (workItem.getExcludedUsers() != null) {
            builder.addAllExcludedUsers(workItem.getExcludedUsers());
        }
        if (workItem.getAdminUsers() != null) {
            builder.addAllAdminUsers(workItem.getAdminUsers());
        }
        if (workItem.getAdminGroups() != null) {
            builder.addAllAdminGroups(workItem.getAdminGroups());
        }
        if (workItem.getComments() != null) {
            builder.addAllComments(this.buildComments(workItem.getComments().values()));
        }
        if (workItem.getAttachments() != null) {
            builder.addAllAttachments(this.buildAttachments(workItem.getAttachments().values()));
        }
        if (nodeInstance.getNotStartedDeadlineTimers() != null) {
            builder.putAllStartDeadlines(this.buildDeadlines(nodeInstance.getNotStartedDeadlineTimers()));
        }
        if (nodeInstance.getNotStartedReassignments() != null) {
            builder.putAllStartReassigments(this.buildReassignments(nodeInstance.getNotStartedReassignments()));
        }
        if (nodeInstance.getNotCompletedDeadlineTimers() != null) {
            builder.putAllCompletedDeadlines(this.buildDeadlines(nodeInstance.getNotCompletedDeadlineTimers()));
        }
        if (nodeInstance.getNotCompletedReassigments() != null) {
            builder.putAllCompletedReassigments(this.buildReassignments(nodeInstance.getNotCompletedReassigments()));
        }
        return builder.build();
    }

    private List<KogitoWorkItemsProtobuf.Comment> buildComments(Iterable<Comment> comments) {
        ArrayList<KogitoWorkItemsProtobuf.Comment> commentsProtobuf = new ArrayList<KogitoWorkItemsProtobuf.Comment>();
        for (Comment comment : comments) {
            KogitoWorkItemsProtobuf.Comment workItemComment = KogitoWorkItemsProtobuf.Comment.newBuilder().setId(((String)((Object)comment.getId())).toString()).setContent((String)((Object)comment.getContent())).setUpdatedBy(comment.getUpdatedBy()).setUpdatedAt(comment.getUpdatedAt().getTime()).build();
            commentsProtobuf.add(workItemComment);
        }
        return commentsProtobuf;
    }

    private List<KogitoWorkItemsProtobuf.Attachment> buildAttachments(Iterable<Attachment> attachments) {
        ArrayList<KogitoWorkItemsProtobuf.Attachment> attachmentProtobuf = new ArrayList<KogitoWorkItemsProtobuf.Attachment>();
        for (Attachment attachment : attachments) {
            KogitoWorkItemsProtobuf.Attachment workItemAttachment = KogitoWorkItemsProtobuf.Attachment.newBuilder().setId(((String)((Object)attachment.getId())).toString()).setContent(((URI)attachment.getContent()).toString()).setUpdatedBy(attachment.getUpdatedBy()).setUpdatedAt(attachment.getUpdatedAt().getTime()).setName(attachment.getName()).build();
            attachmentProtobuf.add(workItemAttachment);
        }
        return attachmentProtobuf;
    }

    private Map<String, KogitoWorkItemsProtobuf.Deadline> buildDeadlines(Map<String, Map<String, Object>> deadlines) {
        HashMap<String, KogitoWorkItemsProtobuf.Deadline> deadlinesProtobuf = new HashMap<String, KogitoWorkItemsProtobuf.Deadline>();
        for (Map.Entry<String, Map<String, Object>> entry : deadlines.entrySet()) {
            KogitoWorkItemsProtobuf.Deadline.Builder builder = KogitoWorkItemsProtobuf.Deadline.newBuilder();
            entry.getValue().forEach((k, v) -> builder.putContent((String)k, v.toString()));
            deadlinesProtobuf.put(entry.getKey(), builder.build());
        }
        return deadlinesProtobuf;
    }

    private Map<String, KogitoWorkItemsProtobuf.Reassignment> buildReassignments(Map<String, Reassignment> reassignments) {
        HashMap<String, KogitoWorkItemsProtobuf.Reassignment> reassignmentsProtobuf = new HashMap<String, KogitoWorkItemsProtobuf.Reassignment>();
        for (Map.Entry<String, Reassignment> entry : reassignments.entrySet()) {
            KogitoWorkItemsProtobuf.Reassignment.Builder builder = KogitoWorkItemsProtobuf.Reassignment.newBuilder();
            builder.addAllGroups(entry.getValue().getPotentialGroups());
            builder.addAllUsers(entry.getValue().getPotentialUsers());
            reassignmentsProtobuf.put(entry.getKey(), builder.build());
        }
        return reassignmentsProtobuf;
    }
}

