/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serialization.process.impl;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.kie.kogito.serialization.process.MarshallerWriterContext;
import org.kie.kogito.serialization.process.ObjectMarshallerStrategy;
import org.kie.kogito.serialization.process.protobuf.KogitoTypesProtobuf;

public class ProtobufVariableWriter {
    private MarshallerWriterContext context;

    public ProtobufVariableWriter(MarshallerWriterContext context) {
        this.context = context;
    }

    public List<KogitoTypesProtobuf.Variable> buildVariables(List<Map.Entry<String, Object>> variables) {
        Comparator comparator = (o1, o2) -> ((String)o1.getKey()).compareTo((String)o2.getKey());
        Collections.sort(variables, comparator);
        ArrayList<KogitoTypesProtobuf.Variable> variablesProtobuf = new ArrayList<KogitoTypesProtobuf.Variable>();
        for (Map.Entry<String, Object> entry : variables) {
            KogitoTypesProtobuf.Variable.Builder variableBuilder = KogitoTypesProtobuf.Variable.newBuilder();
            variableBuilder.setName(entry.getKey());
            if (entry.getValue() != null) {
                Object value = entry.getValue();
                ObjectMarshallerStrategy strategy = this.context.findObjectMarshallerStrategyFor(value);
                variableBuilder.setDataType(entry.getValue().getClass().getName()).setValue((Any)strategy.marshall(value));
            } else {
                variableBuilder.setValue(Any.pack((Message)BytesValue.of((ByteString)ByteString.EMPTY)));
            }
            variablesProtobuf.add(variableBuilder.build());
        }
        return variablesProtobuf;
    }
}

