/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serialization.process.impl.marshallers;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.kie.kogito.serialization.process.ObjectMarshallerStrategy;
import org.kie.kogito.serialization.process.ProcessInstanceMarshallerException;

public class ProtobufObjectMarshallerStrategy
implements ObjectMarshallerStrategy {
    @Override
    public Integer order() {
        return 1;
    }

    @Override
    public boolean acceptForMarshalling(Object value) {
        return true;
    }

    @Override
    public boolean acceptForUnmarshalling(Object value) {
        return ((Any)value).is(BytesValue.class);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object marshall(Object unmarshalled) {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            Any any;
            try (ObjectOutputStream out = new ObjectOutputStream(stream);){
                out.writeObject(unmarshalled);
                any = Any.pack((Message)BytesValue.of((ByteString)ByteString.copyFrom((byte[])stream.toByteArray())));
            }
            return any;
        }
        catch (IOException e) {
            throw new ProcessInstanceMarshallerException("Not possible to unmarshall value: " + unmarshalled, e);
        }
    }

    @Override
    public Object unmarshall(Object marshalled) {
        try {
            Any data = (Any)marshalled;
            BytesValue storedValue = (BytesValue)data.unpack(BytesValue.class);
            if (ByteString.EMPTY.equals((Object)storedValue.getValue())) {
                return null;
            }
            return this.readObject(storedValue.getValue().toByteArray());
        }
        catch (InvalidProtocolBufferException e1) {
            throw new ProcessInstanceMarshallerException("Unexpected error during protobuf object unmarshalling", e1);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Object readObject(byte[] data) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(data);){
            Object object;
            try (ObjectInputStream ois = new ObjectInputStream(is);){
                object = ois.readObject();
            }
            return object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new ProcessInstanceMarshallerException("Unexpected error while trying to read object", e);
        }
    }
}

