/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serialization.process.impl;

import com.google.protobuf.Any;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.context.exclusive.ExclusiveGroupInstance;
import org.jbpm.process.instance.context.swimlane.SwimlaneContextInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.humantask.HumanTaskWorkItemImpl;
import org.jbpm.process.instance.impl.humantask.Reassignment;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.workflow.core.node.AsyncEventNodeInstance;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.node.CompositeContextNodeInstance;
import org.jbpm.workflow.instance.node.DynamicNodeInstance;
import org.jbpm.workflow.instance.node.EventNodeInstance;
import org.jbpm.workflow.instance.node.EventSubProcessNodeInstance;
import org.jbpm.workflow.instance.node.ForEachNodeInstance;
import org.jbpm.workflow.instance.node.HumanTaskNodeInstance;
import org.jbpm.workflow.instance.node.JoinInstance;
import org.jbpm.workflow.instance.node.LambdaSubProcessNodeInstance;
import org.jbpm.workflow.instance.node.MilestoneNodeInstance;
import org.jbpm.workflow.instance.node.RuleSetNodeInstance;
import org.jbpm.workflow.instance.node.StateNodeInstance;
import org.jbpm.workflow.instance.node.SubProcessNodeInstance;
import org.jbpm.workflow.instance.node.TimerNodeInstance;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstanceContainer;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.process.impl.AbstractProcess;
import org.kie.kogito.process.workitem.Attachment;
import org.kie.kogito.process.workitem.Comment;
import org.kie.kogito.process.workitem.TaskMetaEntity;
import org.kie.kogito.process.workitems.InternalKogitoWorkItem;
import org.kie.kogito.process.workitems.impl.KogitoWorkItemImpl;
import org.kie.kogito.serialization.process.MarshallerContextName;
import org.kie.kogito.serialization.process.MarshallerReaderContext;
import org.kie.kogito.serialization.process.ProcessInstanceMarshallerException;
import org.kie.kogito.serialization.process.impl.ProtobufVariableReader;
import org.kie.kogito.serialization.process.protobuf.KogitoNodeInstanceContentsProtobuf;
import org.kie.kogito.serialization.process.protobuf.KogitoProcessInstanceProtobuf;
import org.kie.kogito.serialization.process.protobuf.KogitoTypesProtobuf;
import org.kie.kogito.serialization.process.protobuf.KogitoWorkItemsProtobuf;
import org.kie.kogito.serialization.process.protobuf.ProtobufTypeRegistryFactory;

public class ProtobufProcessInstanceReader {
    private RuleFlowProcessInstance ruleFlowProcessInstance;
    private MarshallerReaderContext context;
    private ProtobufVariableReader varReader;

    public ProtobufProcessInstanceReader(MarshallerReaderContext context) {
        this.context = context;
        this.ruleFlowProcessInstance = new RuleFlowProcessInstance();
        this.varReader = new ProtobufVariableReader(context);
    }

    public RuleFlowProcessInstance read(InputStream input) throws IOException {
        KogitoProcessInstanceProtobuf.ProcessInstance processInstanceProtobuf;
        String format = this.context.get(MarshallerContextName.MARSHALLER_FORMAT);
        if (format != null && "json".equals(format)) {
            KogitoProcessInstanceProtobuf.ProcessInstance.Builder builder = KogitoProcessInstanceProtobuf.ProcessInstance.newBuilder();
            JsonFormat.parser().usingTypeRegistry(ProtobufTypeRegistryFactory.protobufTypeRegistryFactoryInstance().create()).ignoringUnknownFields().merge((Reader)new InputStreamReader(input), (Message.Builder)builder);
            processInstanceProtobuf = builder.build();
        } else {
            processInstanceProtobuf = KogitoProcessInstanceProtobuf.ProcessInstance.parseFrom(input);
        }
        return this.buildWorkflow(processInstanceProtobuf);
    }

    private RuleFlowProcessInstance buildWorkflow(KogitoProcessInstanceProtobuf.ProcessInstance processInstanceProtobuf) {
        RuleFlowProcessInstance processInstance = this.ruleFlowProcessInstance;
        processInstance.setProcess(((AbstractProcess)this.context.get(MarshallerContextName.MARSHALLER_PROCESS)).get());
        processInstance.setId(processInstanceProtobuf.getId());
        processInstance.setProcessId(processInstanceProtobuf.getProcessId());
        processInstance.setState(processInstanceProtobuf.getState());
        processInstance.setSignalCompletion(processInstanceProtobuf.getSignalCompletion());
        processInstance.setStartDate(new Date(processInstanceProtobuf.getStartDate()));
        processInstance.setDescription(processInstanceProtobuf.getDescription());
        processInstance.setDeploymentId(processInstanceProtobuf.getDeploymentId());
        for (String completedNodeId : processInstanceProtobuf.getCompletedNodeIdsList()) {
            processInstance.addCompletedNodeId(completedNodeId);
        }
        processInstance.setCorrelationKey(processInstanceProtobuf.getBusinessKey());
        KogitoTypesProtobuf.SLAContext slaContext = processInstanceProtobuf.getSla();
        if (slaContext.getSlaDueDate() > 0L) {
            processInstance.internalSetSlaDueDate(new Date(slaContext.getSlaDueDate()));
        }
        processInstance.internalSetSlaTimerId(slaContext.getSlaTimerId());
        processInstance.internalSetSlaCompliance(slaContext.getSlaCompliance());
        processInstance.setParentProcessInstanceId(processInstanceProtobuf.getParentProcessInstanceId());
        processInstance.setRootProcessInstanceId(processInstanceProtobuf.getRootProcessInstanceId());
        processInstance.setRootProcessId(processInstanceProtobuf.getRootProcessId());
        processInstance.internalSetErrorNodeId(processInstanceProtobuf.getErrorNodeId());
        processInstance.internalSetErrorMessage(processInstanceProtobuf.getErrorMessage());
        processInstance.setReferenceId(processInstanceProtobuf.getReferenceId());
        if (processInstanceProtobuf.getSwimlaneContextCount() > 0) {
            SwimlaneContextInstance swimlaneContextInstance = (SwimlaneContextInstance)processInstance.getContextInstance("SwimlaneScope");
            for (KogitoTypesProtobuf.SwimlaneContext _swimlane : processInstanceProtobuf.getSwimlaneContextList()) {
                swimlaneContextInstance.setActorId(_swimlane.getSwimlane(), _swimlane.getActorId());
            }
        }
        KogitoTypesProtobuf.WorkflowContext workflowContext = processInstanceProtobuf.getContext();
        for (KogitoTypesProtobuf.NodeInstance nodeInstanceProtobuf : workflowContext.getNodeInstanceList()) {
            NodeInstanceImpl nodeInstanceImpl = this.buildNodeInstance(nodeInstanceProtobuf, (KogitoNodeInstanceContainer)processInstance);
            if (!nodeInstanceProtobuf.hasTriggerDate()) continue;
            nodeInstanceImpl.internalSetTriggerTime(new Date(nodeInstanceProtobuf.getTriggerDate()));
        }
        for (KogitoTypesProtobuf.NodeInstanceGroup group : workflowContext.getExclusiveGroupList()) {
            Function<String, KogitoNodeInstance> finder = nodeInstanceId -> processInstance.getNodeInstance(nodeInstanceId, true);
            processInstance.addContextInstance("ExclusiveGroup", (ContextInstance)this.buildExclusiveGroupInstance(group, finder));
        }
        processInstance.addContextInstance("VariableScope", (ContextInstance)new VariableScopeInstance());
        if (workflowContext.getVariableCount() > 0) {
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)processInstance.getContextInstance("VariableScope");
            this.varReader.buildVariables(workflowContext.getVariableList()).forEach(v -> variableScopeInstance.internalSetVariable(v.getName(), v.getValue()));
        }
        if (workflowContext.getIterationLevelsCount() > 0) {
            processInstance.getIterationLevels().putAll(this.buildIterationLevels(workflowContext.getIterationLevelsList()));
        }
        return processInstance;
    }

    private void setCommonNodeInstanceData(RuleFlowProcessInstance processInstance, KogitoNodeInstanceContainer parentContainer, KogitoTypesProtobuf.NodeInstance nodeInstanceProtobuf, NodeInstanceImpl nodeInstanceImpl) {
        if (nodeInstanceImpl.getStringId() == null) {
            nodeInstanceImpl.setId(nodeInstanceProtobuf.getId());
        }
        if (nodeInstanceImpl.getNodeId() == 0L) {
            nodeInstanceImpl.setNodeId(nodeInstanceProtobuf.getNodeId());
        }
        if (nodeInstanceImpl.getNodeInstanceContainer() == null) {
            nodeInstanceImpl.setNodeInstanceContainer(parentContainer);
        }
        if (nodeInstanceImpl.getProcessInstance() == null) {
            nodeInstanceImpl.setProcessInstance((WorkflowProcessInstance)processInstance);
        }
        nodeInstanceImpl.setLevel(nodeInstanceProtobuf.getLevel() == 0 ? 1 : nodeInstanceProtobuf.getLevel());
    }

    protected NodeInstanceImpl buildNodeInstance(KogitoTypesProtobuf.NodeInstance nodeInstance, KogitoNodeInstanceContainer parent) {
        Any nodeContentProtobuf = nodeInstance.getContent();
        NodeInstanceImpl result = null;
        try {
            GeneratedMessageV3 content;
            if (nodeContentProtobuf.is(KogitoNodeInstanceContentsProtobuf.RuleSetNodeInstanceContent.class)) {
                content = (KogitoNodeInstanceContentsProtobuf.RuleSetNodeInstanceContent)nodeContentProtobuf.unpack(KogitoNodeInstanceContentsProtobuf.RuleSetNodeInstanceContent.class);
                result = this.buildRuleSetNodeInstance((KogitoNodeInstanceContentsProtobuf.RuleSetNodeInstanceContent)content);
            } else if (nodeContentProtobuf.is(KogitoNodeInstanceContentsProtobuf.ForEachNodeInstanceContent.class)) {
                content = (KogitoNodeInstanceContentsProtobuf.ForEachNodeInstanceContent)nodeContentProtobuf.unpack(KogitoNodeInstanceContentsProtobuf.ForEachNodeInstanceContent.class);
                result = this.buildForEachNodeInstance((KogitoNodeInstanceContentsProtobuf.ForEachNodeInstanceContent)content, nodeInstance, parent);
            } else if (nodeContentProtobuf.is(KogitoNodeInstanceContentsProtobuf.LambdaSubProcessNodeInstanceContent.class)) {
                content = (KogitoNodeInstanceContentsProtobuf.LambdaSubProcessNodeInstanceContent)nodeContentProtobuf.unpack(KogitoNodeInstanceContentsProtobuf.LambdaSubProcessNodeInstanceContent.class);
                result = this.buildLambdaSubProcessNodeInstance((KogitoNodeInstanceContentsProtobuf.LambdaSubProcessNodeInstanceContent)content);
            } else if (nodeContentProtobuf.is(KogitoNodeInstanceContentsProtobuf.SubProcessNodeInstanceContent.class)) {
                content = (KogitoNodeInstanceContentsProtobuf.SubProcessNodeInstanceContent)nodeContentProtobuf.unpack(KogitoNodeInstanceContentsProtobuf.SubProcessNodeInstanceContent.class);
                result = this.buildSubProcessNodeInstance((KogitoNodeInstanceContentsProtobuf.SubProcessNodeInstanceContent)content);
            } else if (nodeContentProtobuf.is(KogitoNodeInstanceContentsProtobuf.StateNodeInstanceContent.class)) {
                content = (KogitoNodeInstanceContentsProtobuf.StateNodeInstanceContent)nodeContentProtobuf.unpack(KogitoNodeInstanceContentsProtobuf.StateNodeInstanceContent.class);
                result = this.buildStateNodeInstance((KogitoNodeInstanceContentsProtobuf.StateNodeInstanceContent)content);
            } else if (nodeContentProtobuf.is(KogitoNodeInstanceContentsProtobuf.JoinNodeInstanceContent.class)) {
                content = (KogitoNodeInstanceContentsProtobuf.JoinNodeInstanceContent)nodeContentProtobuf.unpack(KogitoNodeInstanceContentsProtobuf.JoinNodeInstanceContent.class);
                result = this.buildJoinInstance((KogitoNodeInstanceContentsProtobuf.JoinNodeInstanceContent)content);
            } else if (nodeContentProtobuf.is(KogitoNodeInstanceContentsProtobuf.TimerNodeInstanceContent.class)) {
                content = (KogitoNodeInstanceContentsProtobuf.TimerNodeInstanceContent)nodeContentProtobuf.unpack(KogitoNodeInstanceContentsProtobuf.TimerNodeInstanceContent.class);
                result = this.buildTimerNodeInstance((KogitoNodeInstanceContentsProtobuf.TimerNodeInstanceContent)content);
            } else if (nodeContentProtobuf.is(KogitoNodeInstanceContentsProtobuf.EventNodeInstanceContent.class)) {
                result = this.buildEventNodeInstance();
            } else if (nodeContentProtobuf.is(KogitoNodeInstanceContentsProtobuf.MilestoneNodeInstanceContent.class)) {
                content = (KogitoNodeInstanceContentsProtobuf.MilestoneNodeInstanceContent)nodeContentProtobuf.unpack(KogitoNodeInstanceContentsProtobuf.MilestoneNodeInstanceContent.class);
                result = this.buildMilestoneNodeInstance((KogitoNodeInstanceContentsProtobuf.MilestoneNodeInstanceContent)content);
            } else if (nodeContentProtobuf.is(KogitoNodeInstanceContentsProtobuf.DynamicNodeInstanceContent.class)) {
                content = (KogitoNodeInstanceContentsProtobuf.DynamicNodeInstanceContent)nodeContentProtobuf.unpack(KogitoNodeInstanceContentsProtobuf.DynamicNodeInstanceContent.class);
                result = this.buildDynamicNodeInstance((KogitoNodeInstanceContentsProtobuf.DynamicNodeInstanceContent)content, nodeInstance, parent);
            } else if (nodeContentProtobuf.is(KogitoNodeInstanceContentsProtobuf.EventSubProcessNodeInstanceContent.class)) {
                content = (KogitoNodeInstanceContentsProtobuf.EventSubProcessNodeInstanceContent)nodeContentProtobuf.unpack(KogitoNodeInstanceContentsProtobuf.EventSubProcessNodeInstanceContent.class);
                result = this.buildEventSubProcessNodeInstance((KogitoNodeInstanceContentsProtobuf.EventSubProcessNodeInstanceContent)content);
            } else if (nodeContentProtobuf.is(KogitoNodeInstanceContentsProtobuf.CompositeContextNodeInstanceContent.class)) {
                content = (KogitoNodeInstanceContentsProtobuf.CompositeContextNodeInstanceContent)nodeContentProtobuf.unpack(KogitoNodeInstanceContentsProtobuf.CompositeContextNodeInstanceContent.class);
                result = this.buildCompositeContextNodeInstance((KogitoNodeInstanceContentsProtobuf.CompositeContextNodeInstanceContent)content, nodeInstance, parent);
            } else if (nodeContentProtobuf.is(KogitoNodeInstanceContentsProtobuf.WorkItemNodeInstanceContent.class)) {
                content = (KogitoNodeInstanceContentsProtobuf.WorkItemNodeInstanceContent)nodeContentProtobuf.unpack(KogitoNodeInstanceContentsProtobuf.WorkItemNodeInstanceContent.class);
                result = this.buildWorkItemNodeInstance((KogitoNodeInstanceContentsProtobuf.WorkItemNodeInstanceContent)content);
            } else if (nodeContentProtobuf.is(KogitoNodeInstanceContentsProtobuf.AsyncEventNodeInstanceContent.class)) {
                content = (KogitoNodeInstanceContentsProtobuf.AsyncEventNodeInstanceContent)nodeContentProtobuf.unpack(KogitoNodeInstanceContentsProtobuf.AsyncEventNodeInstanceContent.class);
                result = this.buildAsyncEventNodeInstance((KogitoNodeInstanceContentsProtobuf.AsyncEventNodeInstanceContent)content);
            }
            if (Objects.isNull(result)) {
                throw new IllegalArgumentException("Unknown node instance");
            }
            this.setCommonNodeInstanceData(this.ruleFlowProcessInstance, parent, nodeInstance, result);
            KogitoTypesProtobuf.SLAContext slaNodeInstanceContext = nodeInstance.getSla();
            result.internalSetSlaCompliance(slaNodeInstanceContext.getSlaCompliance());
            if (slaNodeInstanceContext.getSlaDueDate() > 0L) {
                result.internalSetSlaDueDate(new Date(slaNodeInstanceContext.getSlaDueDate()));
            }
            result.internalSetSlaTimerId(slaNodeInstanceContext.getSlaTimerId());
            return result;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot read node instance content");
        }
    }

    private NodeInstanceImpl buildAsyncEventNodeInstance(KogitoNodeInstanceContentsProtobuf.AsyncEventNodeInstanceContent content) {
        AsyncEventNodeInstance nodeInstance = new AsyncEventNodeInstance();
        nodeInstance.setJobId(content.getJobId());
        return nodeInstance;
    }

    private NodeInstanceImpl buildCompositeContextNodeInstance(KogitoNodeInstanceContentsProtobuf.CompositeContextNodeInstanceContent content, KogitoTypesProtobuf.NodeInstance protoNodeInstance, KogitoNodeInstanceContainer parentContainer) {
        CompositeContextNodeInstance nodeInstance = new CompositeContextNodeInstance();
        if (content.getTimerInstanceIdCount() > 0) {
            ArrayList<String> timerInstances = new ArrayList<String>();
            for (String _timerId : content.getTimerInstanceIdList()) {
                timerInstances.add(_timerId);
            }
            nodeInstance.internalSetTimerInstances(timerInstances);
        }
        this.setCommonNodeInstanceData(this.ruleFlowProcessInstance, parentContainer, protoNodeInstance, (NodeInstanceImpl)nodeInstance);
        this.buildWorkflowContext(nodeInstance, content.getContext());
        return nodeInstance;
    }

    private NodeInstanceImpl buildEventSubProcessNodeInstance(KogitoNodeInstanceContentsProtobuf.EventSubProcessNodeInstanceContent content) {
        EventSubProcessNodeInstance nodeInstance = new EventSubProcessNodeInstance();
        if (content.getTimerInstanceIdCount() > 0) {
            ArrayList<String> timerInstances = new ArrayList<String>();
            for (String _timerId : content.getTimerInstanceIdList()) {
                timerInstances.add(_timerId);
            }
            nodeInstance.internalSetTimerInstances(timerInstances);
        }
        this.buildWorkflowContext((CompositeContextNodeInstance)nodeInstance, content.getContext());
        return nodeInstance;
    }

    private NodeInstanceImpl buildDynamicNodeInstance(KogitoNodeInstanceContentsProtobuf.DynamicNodeInstanceContent content, KogitoTypesProtobuf.NodeInstance protoNodeInstance, KogitoNodeInstanceContainer parentContainer) {
        DynamicNodeInstance nodeInstance = new DynamicNodeInstance();
        if (content.getTimerInstanceIdCount() > 0) {
            ArrayList<String> timerInstances = new ArrayList<String>();
            for (String _timerId : content.getTimerInstanceIdList()) {
                timerInstances.add(_timerId);
            }
            nodeInstance.internalSetTimerInstances(timerInstances);
        }
        this.setCommonNodeInstanceData(this.ruleFlowProcessInstance, parentContainer, protoNodeInstance, (NodeInstanceImpl)nodeInstance);
        this.buildWorkflowContext((CompositeContextNodeInstance)nodeInstance, content.getContext());
        return nodeInstance;
    }

    private NodeInstanceImpl buildMilestoneNodeInstance(KogitoNodeInstanceContentsProtobuf.MilestoneNodeInstanceContent content) {
        MilestoneNodeInstance nodeInstance = new MilestoneNodeInstance();
        if (content.getTimerInstanceIdCount() > 0) {
            ArrayList<String> timerInstances = new ArrayList<String>();
            for (String _timerId : content.getTimerInstanceIdList()) {
                timerInstances.add(_timerId);
            }
            nodeInstance.internalSetTimerInstances(timerInstances);
        }
        return nodeInstance;
    }

    private NodeInstanceImpl buildEventNodeInstance() {
        return new EventNodeInstance();
    }

    private NodeInstanceImpl buildTimerNodeInstance(KogitoNodeInstanceContentsProtobuf.TimerNodeInstanceContent content) {
        TimerNodeInstance nodeInstance = new TimerNodeInstance();
        nodeInstance.internalSetTimerId(content.getTimerId());
        return nodeInstance;
    }

    private NodeInstanceImpl buildJoinInstance(KogitoNodeInstanceContentsProtobuf.JoinNodeInstanceContent content) {
        JoinInstance nodeInstance = new JoinInstance();
        if (content.getTriggerCount() > 0) {
            HashMap<Long, Integer> triggers = new HashMap<Long, Integer>();
            for (KogitoNodeInstanceContentsProtobuf.JoinNodeInstanceContent.JoinTrigger _join : content.getTriggerList()) {
                triggers.put(_join.getNodeId(), _join.getCounter());
            }
            nodeInstance.internalSetTriggers(triggers);
        }
        return nodeInstance;
    }

    private NodeInstanceImpl buildStateNodeInstance(KogitoNodeInstanceContentsProtobuf.StateNodeInstanceContent content) {
        StateNodeInstance nodeInstance = new StateNodeInstance();
        if (content.getTimerInstanceIdCount() > 0) {
            ArrayList<String> timerInstances = new ArrayList<String>();
            for (String _timerId : content.getTimerInstanceIdList()) {
                timerInstances.add(_timerId);
            }
            nodeInstance.internalSetTimerInstances(timerInstances);
        }
        return nodeInstance;
    }

    private NodeInstanceImpl buildSubProcessNodeInstance(KogitoNodeInstanceContentsProtobuf.SubProcessNodeInstanceContent content) {
        SubProcessNodeInstance nodeInstance = new SubProcessNodeInstance();
        nodeInstance.internalSetProcessInstanceId(content.getProcessInstanceId());
        if (content.getTimerInstanceIdCount() > 0) {
            ArrayList<String> timerInstances = new ArrayList<String>();
            for (String timerId : content.getTimerInstanceIdList()) {
                timerInstances.add(timerId);
            }
            nodeInstance.internalSetTimerInstances(timerInstances);
        }
        return nodeInstance;
    }

    private NodeInstanceImpl buildLambdaSubProcessNodeInstance(KogitoNodeInstanceContentsProtobuf.LambdaSubProcessNodeInstanceContent content) {
        LambdaSubProcessNodeInstance nodeInstance = new LambdaSubProcessNodeInstance();
        nodeInstance.internalSetProcessInstanceId(content.getProcessInstanceId());
        if (content.getTimerInstanceIdCount() > 0) {
            nodeInstance.internalSetTimerInstances(new ArrayList(content.getTimerInstanceIdList()));
        }
        return nodeInstance;
    }

    private NodeInstanceImpl buildForEachNodeInstance(KogitoNodeInstanceContentsProtobuf.ForEachNodeInstanceContent content, KogitoTypesProtobuf.NodeInstance protoNodeInstance, KogitoNodeInstanceContainer parentContainer) {
        ForEachNodeInstance nodeInstance = new ForEachNodeInstance();
        nodeInstance.setExecutedInstances(content.getExecutedInstances());
        nodeInstance.setTotalInstances(content.getTotalInstances());
        nodeInstance.setHasAsyncInstances(content.getHasAsyncInstances());
        this.setCommonNodeInstanceData(this.ruleFlowProcessInstance, parentContainer, protoNodeInstance, (NodeInstanceImpl)nodeInstance);
        this.buildWorkflowContext((CompositeContextNodeInstance)nodeInstance, content.getContext());
        return nodeInstance;
    }

    private NodeInstanceImpl buildRuleSetNodeInstance(KogitoNodeInstanceContentsProtobuf.RuleSetNodeInstanceContent content) {
        RuleSetNodeInstance nodeInstance = new RuleSetNodeInstance();
        nodeInstance.setRuleFlowGroup(content.getRuleFlowGroup());
        if (content.getTimerInstanceIdCount() > 0) {
            nodeInstance.internalSetTimerInstances(new ArrayList(content.getTimerInstanceIdList()));
        }
        return nodeInstance;
    }

    private NodeInstanceImpl buildWorkItemNodeInstance(KogitoNodeInstanceContentsProtobuf.WorkItemNodeInstanceContent content) {
        try {
            WorkItemNodeInstance nodeInstance = this.instanceWorkItem(content);
            if (nodeInstance instanceof HumanTaskNodeInstance) {
                HumanTaskNodeInstance humanTaskNodeInstance = (HumanTaskNodeInstance)nodeInstance;
                HumanTaskWorkItemImpl workItem = (HumanTaskWorkItemImpl)nodeInstance.getWorkItem();
                Any workItemDataMessage = content.getWorkItemData();
                if (workItemDataMessage.is(KogitoWorkItemsProtobuf.HumanTaskWorkItemData.class)) {
                    KogitoWorkItemsProtobuf.HumanTaskWorkItemData workItemData = (KogitoWorkItemsProtobuf.HumanTaskWorkItemData)workItemDataMessage.unpack(KogitoWorkItemsProtobuf.HumanTaskWorkItemData.class);
                    humanTaskNodeInstance.getNotCompletedDeadlineTimers().putAll(this.buildDeadlines(workItemData.getCompletedDeadlinesMap()));
                    humanTaskNodeInstance.getNotCompletedReassigments().putAll(this.buildReassignments(workItemData.getCompletedReassigmentsMap()));
                    humanTaskNodeInstance.getNotStartedDeadlineTimers().putAll(this.buildDeadlines(workItemData.getStartDeadlinesMap()));
                    humanTaskNodeInstance.getNotStartedReassignments().putAll(this.buildReassignments(workItemData.getStartReassigmentsMap()));
                    if (workItemData.hasTaskName()) {
                        workItem.setTaskName(workItemData.getTaskName());
                    }
                    if (workItemData.hasTaskDescription()) {
                        workItem.setTaskDescription(workItemData.getTaskDescription());
                    }
                    if (workItemData.hasTaskPriority()) {
                        workItem.setTaskPriority(workItemData.getTaskPriority());
                    }
                    if (workItemData.hasTaskReferenceName()) {
                        workItem.setReferenceName(workItemData.getTaskReferenceName());
                    }
                    if (workItemData.hasActualOwner()) {
                        workItem.setActualOwner(workItemData.getActualOwner());
                    }
                    workItem.getAdminUsers().addAll(workItemData.getAdminUsersList());
                    workItem.getAdminGroups().addAll(workItemData.getAdminGroupsList());
                    workItem.getPotentialUsers().addAll(workItemData.getPotUsersList());
                    workItem.getPotentialGroups().addAll(workItemData.getPotGroupsList());
                    workItem.getExcludedUsers().addAll(workItemData.getExcludedUsersList());
                    workItem.getComments().putAll(workItemData.getCommentsList().stream().map(this::buildComment).collect(Collectors.toMap(TaskMetaEntity::getId, Function.identity())));
                    workItem.getAttachments().putAll(workItemData.getAttachmentsList().stream().map(this::buildAttachment).collect(Collectors.toMap(TaskMetaEntity::getId, Function.identity())));
                }
            }
            nodeInstance.internalSetWorkItemId(content.getWorkItemId());
            KogitoWorkItemImpl workItem = (KogitoWorkItemImpl)nodeInstance.getWorkItem();
            workItem.setId(content.getWorkItemId());
            workItem.setProcessInstanceId(this.ruleFlowProcessInstance.getStringId());
            workItem.setName(content.getName());
            workItem.setState(content.getState());
            workItem.setDeploymentId(this.ruleFlowProcessInstance.getDeploymentId());
            workItem.setProcessInstance((KogitoProcessInstance)this.ruleFlowProcessInstance);
            workItem.setPhaseId(content.getPhaseId());
            workItem.setPhaseStatus(content.getPhaseStatus());
            workItem.setStartDate(new Date(content.getStartDate()));
            if (content.getCompleteDate() > 0L) {
                workItem.setCompleteDate(new Date(content.getCompleteDate()));
            }
            if (content.getTimerInstanceIdCount() > 0) {
                nodeInstance.internalSetTimerInstances(new ArrayList(content.getTimerInstanceIdList()));
            }
            nodeInstance.internalSetProcessInstanceId(content.getErrorHandlingProcessInstanceId());
            this.varReader.buildVariables(content.getVariableList()).forEach(var -> nodeInstance.getWorkItem().getParameters().put(var.getName(), var.getValue()));
            this.varReader.buildVariables(content.getResultList()).forEach(var -> nodeInstance.getWorkItem().getResults().put(var.getName(), var.getValue()));
            return nodeInstance;
        }
        catch (InvalidProtocolBufferException ex) {
            throw new ProcessInstanceMarshallerException("cannot unpack node instance", ex);
        }
    }

    private WorkItemNodeInstance instanceWorkItem(KogitoNodeInstanceContentsProtobuf.WorkItemNodeInstanceContent content) {
        if (content.hasWorkItemData()) {
            Any workItemDataMessage = content.getWorkItemData();
            if (workItemDataMessage.is(KogitoWorkItemsProtobuf.HumanTaskWorkItemData.class)) {
                HumanTaskNodeInstance nodeInstance = new HumanTaskNodeInstance();
                HumanTaskWorkItemImpl workItem = new HumanTaskWorkItemImpl();
                nodeInstance.internalSetWorkItem((InternalKogitoWorkItem)workItem);
                return nodeInstance;
            }
            throw new ProcessInstanceMarshallerException("Don't know which type of work item is");
        }
        WorkItemNodeInstance nodeInstance = new WorkItemNodeInstance();
        KogitoWorkItemImpl workItem = new KogitoWorkItemImpl();
        nodeInstance.internalSetWorkItem((InternalKogitoWorkItem)workItem);
        return nodeInstance;
    }

    private void buildWorkflowContext(CompositeContextNodeInstance container, KogitoTypesProtobuf.WorkflowContext workflowContext) {
        if (workflowContext.getNodeInstanceCount() > 0) {
            for (KogitoTypesProtobuf.NodeInstance nodeInstanceProtobuf : workflowContext.getNodeInstanceList()) {
                this.buildNodeInstance(nodeInstanceProtobuf, (KogitoNodeInstanceContainer)container);
            }
        }
        for (KogitoTypesProtobuf.NodeInstanceGroup group : workflowContext.getExclusiveGroupList()) {
            Function<String, KogitoNodeInstance> finder = nodeInstanceId -> container.getNodeInstance(nodeInstanceId, true);
            container.addContextInstance("ExclusiveGroup", (ContextInstance)this.buildExclusiveGroupInstance(group, finder));
        }
        container.addContextInstance("VariableScope", (ContextInstance)new VariableScopeInstance());
        if (workflowContext.getVariableCount() > 0) {
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)container.getContextInstance("VariableScope");
            this.varReader.buildVariables(workflowContext.getVariableList()).forEach(v -> variableScopeInstance.internalSetVariable(v.getName(), v.getValue()));
        }
        if (workflowContext.getIterationLevelsCount() > 0) {
            container.getIterationLevels().putAll(this.buildIterationLevels(workflowContext.getIterationLevelsList()));
        }
    }

    private ExclusiveGroupInstance buildExclusiveGroupInstance(KogitoTypesProtobuf.NodeInstanceGroup group, Function<String, KogitoNodeInstance> finder) {
        ExclusiveGroupInstance exclusiveGroupInstance = new ExclusiveGroupInstance();
        for (String nodeInstanceId : group.getGroupNodeInstanceIdList()) {
            KogitoNodeInstance kogitoNodeInstance = finder.apply(nodeInstanceId);
            if (kogitoNodeInstance == null) {
                throw new IllegalArgumentException("Could not find node instance when deserializing exclusive group instance: " + nodeInstanceId);
            }
            exclusiveGroupInstance.addNodeInstance(kogitoNodeInstance);
        }
        return exclusiveGroupInstance;
    }

    private Map<String, Integer> buildIterationLevels(List<KogitoTypesProtobuf.IterationLevel> iterationLevel) {
        Function<KogitoTypesProtobuf.IterationLevel, String> mapKey = KogitoTypesProtobuf.IterationLevel::getId;
        Function<KogitoTypesProtobuf.IterationLevel, Integer> mapValue = KogitoTypesProtobuf.IterationLevel::getLevel;
        return iterationLevel.stream().collect(Collectors.toMap(mapKey, mapValue));
    }

    private Comment buildComment(KogitoWorkItemsProtobuf.Comment comment) {
        Comment result = new Comment(comment.getId(), comment.getUpdatedBy());
        result.setContent((Serializable)((Object)comment.getContent()));
        result.setUpdatedAt(new Date(comment.getUpdatedAt()));
        return result;
    }

    private Attachment buildAttachment(KogitoWorkItemsProtobuf.Attachment attachment) {
        Attachment result = new Attachment(attachment.getId(), attachment.getUpdatedBy());
        result.setContent((Serializable)URI.create(attachment.getContent()));
        result.setUpdatedAt(new Date(attachment.getUpdatedAt()));
        result.setName(attachment.getName());
        return result;
    }

    private Map<String, Map<String, Object>> buildDeadlines(Map<String, KogitoWorkItemsProtobuf.Deadline> deadlinesProtobuf) {
        HashMap<String, Map<String, Object>> deadlines = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, KogitoWorkItemsProtobuf.Deadline> entry : deadlinesProtobuf.entrySet()) {
            HashMap<String, String> notification = new HashMap<String, String>();
            for (Map.Entry<String, String> pair : entry.getValue().getContentMap().entrySet()) {
                notification.put(pair.getKey(), pair.getValue());
            }
            deadlines.put(entry.getKey(), notification);
        }
        return deadlines;
    }

    private Map<String, Reassignment> buildReassignments(Map<String, KogitoWorkItemsProtobuf.Reassignment> reassignmentsProtobuf) {
        HashMap<String, Reassignment> reassignments = new HashMap<String, Reassignment>();
        for (Map.Entry<String, KogitoWorkItemsProtobuf.Reassignment> entry : reassignmentsProtobuf.entrySet()) {
            reassignments.put(entry.getKey(), new Reassignment(entry.getValue().getUsersList().stream().collect(Collectors.toSet()), entry.getValue().getGroupsList().stream().collect(Collectors.toSet())));
        }
        return reassignments;
    }
}

