/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serialization.process.impl.marshallers;

import com.google.protobuf.Any;
import com.google.protobuf.Int64Value;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import org.kie.kogito.serialization.process.ObjectMarshallerStrategy;
import org.kie.kogito.serialization.process.ProcessInstanceMarshallerException;

public class ProtobufLongMarshallerStrategy
implements ObjectMarshallerStrategy {
    @Override
    public boolean acceptForMarshalling(Object value) {
        return Long.class.equals(value.getClass());
    }

    @Override
    public boolean acceptForUnmarshalling(Object value) {
        return ((Any)value).is(Int64Value.class);
    }

    @Override
    public Object marshall(Object unmarshalled) {
        return Any.pack((Message)Int64Value.of((long)((Long)unmarshalled)));
    }

    @Override
    public Object unmarshall(Object marshalled) {
        try {
            Any data = (Any)marshalled;
            Int64Value storedValue = (Int64Value)data.unpack(Int64Value.class);
            return storedValue.getValue();
        }
        catch (InvalidProtocolBufferException e1) {
            throw new ProcessInstanceMarshallerException("Error trying to unmarshalling a long value", e1);
        }
    }
}

