/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serialization.process.impl;

import com.google.protobuf.Any;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.BooleanDataType;
import org.jbpm.process.core.datatype.impl.type.FloatDataType;
import org.jbpm.process.core.datatype.impl.type.IntegerDataType;
import org.jbpm.process.core.datatype.impl.type.ListDataType;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.process.core.datatype.impl.type.StringDataType;
import org.kie.kogito.serialization.process.MarshallerReaderContext;
import org.kie.kogito.serialization.process.ObjectMarshallerStrategy;
import org.kie.kogito.serialization.process.protobuf.KogitoTypesProtobuf;

public class ProtobufVariableReader {
    private DataType[] dataTypes = new DataType[]{new BooleanDataType(), new FloatDataType(), new IntegerDataType(), new ListDataType(), new StringDataType()};
    private MarshallerReaderContext context;

    public ProtobufVariableReader(MarshallerReaderContext context) {
        this.context = context;
    }

    public List<Variable> buildVariables(List<KogitoTypesProtobuf.Variable> variablesProtobuf) {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        for (KogitoTypesProtobuf.Variable var : variablesProtobuf) {
            Variable storedVar = new Variable();
            storedVar.setName(var.getName());
            Any value = var.getValue();
            ObjectMarshallerStrategy strategy = this.context.findObjectUnmarshallerStrategyFor(value);
            Object varValue = strategy.unmarshall(value);
            if (varValue != null) {
                storedVar.setType(this.buildDataType(varValue.getClass().getCanonicalName()));
                storedVar.setValue(varValue);
            } else {
                storedVar.setType((DataType)new ObjectDataType("java.lang.Object"));
            }
            variables.add(storedVar);
        }
        return variables;
    }

    private DataType buildDataType(String dataType) {
        try {
            if (dataType == null || dataType.isEmpty()) {
                return new ObjectDataType("java.lang.Object");
            }
            Optional<DataType> foundDataType = Arrays.stream(this.dataTypes).filter(e -> e.getStringType().equals(dataType)).findAny();
            if (foundDataType.isPresent()) {
                return foundDataType.get();
            }
            Class.forName(dataType);
            return new ObjectDataType(dataType);
        }
        catch (ClassNotFoundException e2) {
            return new ObjectDataType("java.lang.Object");
        }
    }
}

