/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serialization.process.protobuf;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.EnumValueDescriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.protostream.impl.SerializationContextImpl;
import org.kie.kogito.serialization.process.protobuf.ProtobufTypeProvider;

public class ProtostreamProtobufAdapterTypeProvider
implements ProtobufTypeProvider {
    @Override
    public Collection<Descriptors.Descriptor> descriptors() {
        try {
            return this.build().stream().flatMap(e -> e.getMessageTypes().stream()).collect(Collectors.toList());
        }
        catch (Exception e2) {
            throw new RuntimeException("Conversion protostream protobuf type not possible", e2);
        }
    }

    private Collection<String> protostreamDescriptors() {
        return Arrays.asList("META-INF/kogito-types.proto", "META-INF/application-types.proto");
    }

    private List<Descriptors.FileDescriptor> build() throws IOException, Descriptors.DescriptorValidationException {
        SerializationContextImpl context = this.buildSerializationContext();
        ArrayList<Descriptors.FileDescriptor> protos = new ArrayList<Descriptors.FileDescriptor>();
        Map descriptors = context.getFileDescriptors();
        for (Map.Entry entry : descriptors.entrySet()) {
            Descriptors.FileDescriptor[] deps = protos.toArray(new Descriptors.FileDescriptor[protos.size()]);
            protos.add(Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)this.buildMessageTypes((FileDescriptor)entry.getValue()), (Descriptors.FileDescriptor[])deps));
            protos.add(Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)this.buildEnumTypes((FileDescriptor)entry.getValue()), (Descriptors.FileDescriptor[])deps));
        }
        return protos;
    }

    private SerializationContextImpl buildSerializationContext() throws IOException, Descriptors.DescriptorValidationException {
        SerializationContextImpl context = new SerializationContextImpl(Configuration.builder().build());
        for (String protoFile : this.protostreamDescriptors()) {
            InputStream is = this.getInputStream(protoFile);
            try {
                if (is == null) continue;
                int idx = protoFile.indexOf(File.separator);
                String fileName = idx >= 0 && idx + 1 < protoFile.length() ? protoFile.substring(idx + 1) : protoFile;
                FileDescriptorSource source = new FileDescriptorSource().addProtoFile(fileName, is);
                context.registerProtoFiles(source);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        return context;
    }

    private InputStream getInputStream(String protoFile) {
        InputStream is = ProtostreamProtobufAdapterTypeProvider.class.getClassLoader().getResourceAsStream(protoFile);
        if (is == null && Thread.currentThread().getContextClassLoader() != null) {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(protoFile);
        }
        return is;
    }

    private DescriptorProtos.FileDescriptorProto buildEnumTypes(FileDescriptor descriptor) {
        DescriptorProtos.FileDescriptorProto.Builder protoFileBuilder = DescriptorProtos.FileDescriptorProto.newBuilder();
        protoFileBuilder.setPackage(descriptor.getPackage());
        protoFileBuilder.setName(descriptor.getName());
        for (EnumDescriptor enumDescriptor : descriptor.getEnumTypes()) {
            protoFileBuilder.addEnumType(this.buildEnum(enumDescriptor));
        }
        return protoFileBuilder.build();
    }

    private DescriptorProtos.EnumDescriptorProto buildEnum(EnumDescriptor enumDescriptor) {
        DescriptorProtos.EnumDescriptorProto.Builder enumBuilder = DescriptorProtos.EnumDescriptorProto.newBuilder();
        enumBuilder.setName(enumDescriptor.getName());
        for (EnumValueDescriptor enumValueDescriptor : enumDescriptor.getValues()) {
            enumBuilder.addValue(this.buildEnumValue(enumValueDescriptor));
        }
        return enumBuilder.build();
    }

    private DescriptorProtos.EnumValueDescriptorProto buildEnumValue(EnumValueDescriptor enumValueDescriptor) {
        DescriptorProtos.EnumValueDescriptorProto.Builder enumValueBuilder = DescriptorProtos.EnumValueDescriptorProto.newBuilder();
        enumValueBuilder.setName(enumValueDescriptor.getName());
        enumValueBuilder.setNumber(enumValueDescriptor.getNumber());
        return enumValueBuilder.build();
    }

    private DescriptorProtos.FileDescriptorProto buildMessageTypes(FileDescriptor descriptor) {
        DescriptorProtos.FileDescriptorProto.Builder protoFileBuilder = DescriptorProtos.FileDescriptorProto.newBuilder();
        protoFileBuilder.setPackage(descriptor.getPackage());
        protoFileBuilder.setName(descriptor.getName());
        for (Descriptor message : descriptor.getMessageTypes()) {
            protoFileBuilder.addMessageType(this.buildMessage(message));
        }
        return protoFileBuilder.build();
    }

    private DescriptorProtos.DescriptorProto buildMessage(Descriptor descriptor) {
        DescriptorProtos.DescriptorProto.Builder messageBuilder = DescriptorProtos.DescriptorProto.newBuilder();
        messageBuilder.setName(descriptor.getName());
        for (FieldDescriptor fieldDescriptor : descriptor.getFields()) {
            messageBuilder.addField(this.buildFieldDescriptor(fieldDescriptor));
        }
        return messageBuilder.build();
    }

    private DescriptorProtos.FieldDescriptorProto buildFieldDescriptor(FieldDescriptor descriptor) {
        DescriptorProtos.FieldDescriptorProto.Builder fieldBuilder = DescriptorProtos.FieldDescriptorProto.newBuilder();
        fieldBuilder.setName(descriptor.getName());
        fieldBuilder.setNumber(descriptor.getNumber());
        fieldBuilder.setType(this.buildFieldTypeDescriptor(descriptor.getType()));
        EnumSet<DescriptorProtos.FieldDescriptorProto.Type> set = EnumSet.of(DescriptorProtos.FieldDescriptorProto.Type.TYPE_ENUM, DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE);
        if (set.contains(fieldBuilder.getType())) {
            fieldBuilder.setTypeName(descriptor.getTypeName());
        }
        fieldBuilder.setProto3Optional(!descriptor.isRequired());
        return fieldBuilder.build();
    }

    private DescriptorProtos.FieldDescriptorProto.Type buildFieldTypeDescriptor(Type type) {
        switch (type) {
            case BOOL: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL;
            }
            case BYTES: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES;
            }
            case DOUBLE: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE;
            }
            case ENUM: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_ENUM;
            }
            case FIXED32: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_FIXED32;
            }
            case FIXED64: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_FIXED64;
            }
            case FLOAT: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_FLOAT;
            }
            case GROUP: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_GROUP;
            }
            case INT32: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32;
            }
            case INT64: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64;
            }
            case MESSAGE: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE;
            }
            case SFIXED32: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_SFIXED32;
            }
            case SFIXED64: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_SFIXED64;
            }
            case SINT32: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_SINT32;
            }
            case SINT64: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_SINT64;
            }
            case STRING: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING;
            }
            case UINT32: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_UINT32;
            }
            case UINT64: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_UINT64;
            }
        }
        throw new RuntimeException("Conversion protostream protobuf type not found");
    }
}

