/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.flow.serialization.impl;

import com.google.protobuf.Any;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jbpm.flow.serialization.MarshallerContextName;
import org.jbpm.flow.serialization.MarshallerWriterContext;
import org.jbpm.flow.serialization.NodeInstanceWriter;
import org.jbpm.flow.serialization.ProcessInstanceMarshallerListener;
import org.jbpm.flow.serialization.impl.ProtobufVariableWriter;
import org.jbpm.flow.serialization.protobuf.KogitoProcessInstanceProtobuf;
import org.jbpm.flow.serialization.protobuf.KogitoTypesProtobuf;
import org.jbpm.flow.serialization.protobuf.ProtobufTypeRegistryFactory;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.ContextInstanceContainer;
import org.jbpm.process.instance.ContextableInstance;
import org.jbpm.process.instance.context.exclusive.ExclusiveGroupInstance;
import org.jbpm.process.instance.context.swimlane.SwimlaneContextInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcessInstance;
import org.kie.kogito.process.impl.AbstractProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufProcessInstanceWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtobufProcessInstanceWriter.class);
    private MarshallerWriterContext context;
    private ProtobufVariableWriter varWriter;
    private ProcessInstanceMarshallerListener[] listeners;

    public ProtobufProcessInstanceWriter(MarshallerWriterContext context) {
        this.context = context;
        this.varWriter = new ProtobufVariableWriter(context);
        this.listeners = context.get(MarshallerContextName.MARSHALLER_INSTANCE_LISTENER);
    }

    public void writeProcessInstance(WorkflowProcessInstanceImpl workFlow, OutputStream os) throws IOException {
        this.context.set(MarshallerContextName.MARSHALLER_PROCESS_INSTANCE, (RuleFlowProcessInstance)workFlow);
        LOGGER.debug("writing process instance {}", (Object)workFlow.getId());
        KogitoProcessRuntime runtime = ((AbstractProcess)this.context.get(MarshallerContextName.MARSHALLER_PROCESS)).getProcessRuntime();
        Arrays.stream(this.listeners).forEach(e -> e.beforeMarshallProcess(runtime, (KogitoWorkflowProcessInstance)workFlow));
        KogitoProcessInstanceProtobuf.ProcessInstance.Builder instance = KogitoProcessInstanceProtobuf.ProcessInstance.newBuilder().setId(workFlow.getStringId()).setProcessId(workFlow.getProcessId()).setState(workFlow.getState()).setProcessType(workFlow.getProcess().getType()).setSignalCompletion(workFlow.isSignalCompletion());
        if (workFlow.getProcessVersion() != null) {
            instance.setProcessVersion(workFlow.getProcessVersion());
        }
        if (workFlow.getStartDate() != null) {
            instance.setStartDate(workFlow.getStartDate().getTime());
        }
        if (workFlow.getDescription() != null) {
            instance.setDescription(workFlow.getDescription());
        }
        if (workFlow.getDeploymentId() != null) {
            instance.setDeploymentId(workFlow.getDeploymentId());
        }
        instance.addAllCompletedNodeIds(workFlow.getCompletedNodeIds());
        if (workFlow.getCorrelationKey() != null) {
            instance.setBusinessKey(workFlow.getCorrelationKey());
        }
        instance.setSla(this.buildSLAContext(workFlow.getSlaCompliance(), workFlow.getSlaDueDate(), workFlow.getSlaTimerId()));
        if (workFlow.getCancelTimerId() != null) {
            instance.setCancelTimerId(workFlow.getCancelTimerId());
        }
        if (workFlow.getParentProcessInstanceId() != null) {
            instance.setParentProcessInstanceId(workFlow.getParentProcessInstanceId());
        }
        if (workFlow.getRootProcessInstanceId() != null) {
            instance.setRootProcessInstanceId(workFlow.getRootProcessInstanceId());
        }
        if (workFlow.getRootProcessId() != null) {
            instance.setRootProcessId(workFlow.getRootProcessId());
        }
        if (workFlow.getNodeIdInError() != null) {
            instance.setErrorNodeId(workFlow.getNodeIdInError());
        }
        if (workFlow.getErrorMessage() != null) {
            instance.setErrorMessage(workFlow.getErrorMessage());
        }
        if (workFlow.getReferenceId() != null) {
            instance.setReferenceId(workFlow.getReferenceId());
        }
        instance.addAllSwimlaneContext(this.buildSwimlaneContexts((SwimlaneContextInstance)workFlow.getContextInstance("SwimlaneScope")));
        instance.setContext(this.buildWorkflowContext(workFlow));
        KogitoProcessInstanceProtobuf.ProcessInstance piProtobuf = instance.build();
        String format = this.context.get(MarshallerContextName.MARSHALLER_FORMAT);
        if (format != null && "json".equals(format)) {
            os.write(JsonFormat.printer().usingTypeRegistry(ProtobufTypeRegistryFactory.protobufTypeRegistryFactoryInstance().create()).print((MessageOrBuilder)piProtobuf).getBytes());
        } else {
            piProtobuf.writeTo(os);
        }
    }

    private KogitoTypesProtobuf.SLAContext buildSLAContext(int slaCompliance, Date slaDueDate, String slaTimerId) {
        KogitoTypesProtobuf.SLAContext.Builder slaContextBuilder = KogitoTypesProtobuf.SLAContext.newBuilder().setSlaCompliance(slaCompliance);
        if (slaDueDate != null) {
            slaContextBuilder.setSlaDueDate(slaDueDate.getTime());
        }
        if (slaTimerId != null) {
            slaContextBuilder.setSlaTimerId(slaTimerId);
        }
        return slaContextBuilder.build();
    }

    private List<KogitoTypesProtobuf.SwimlaneContext> buildSwimlaneContexts(SwimlaneContextInstance swimlaneContextInstance) {
        if (swimlaneContextInstance == null) {
            return Collections.emptyList();
        }
        ArrayList<KogitoTypesProtobuf.SwimlaneContext> contexts = new ArrayList<KogitoTypesProtobuf.SwimlaneContext>();
        Map swimlaneActors = swimlaneContextInstance.getSwimlaneActors();
        for (Map.Entry entry : swimlaneActors.entrySet()) {
            contexts.add(KogitoTypesProtobuf.SwimlaneContext.newBuilder().setSwimlane((String)entry.getKey()).setActorId((String)entry.getValue()).build());
        }
        return contexts;
    }

    private KogitoTypesProtobuf.WorkflowContext buildWorkflowContext(List<NodeInstance> nodeInstances, List<ContextInstance> exclusiveGroupInstances, List<Map.Entry<String, Object>> variables, List<Map.Entry<String, Integer>> iterationlevels) {
        KogitoTypesProtobuf.WorkflowContext.Builder workflowContextBuilder = KogitoTypesProtobuf.WorkflowContext.newBuilder();
        workflowContextBuilder.addAllNodeInstance(this.buildNodeInstances(nodeInstances));
        workflowContextBuilder.addAllExclusiveGroup(this.buildGroups(exclusiveGroupInstances));
        workflowContextBuilder.addAllVariable(this.varWriter.buildVariables(variables));
        workflowContextBuilder.addAllIterationLevels(this.buildIterationLevels(iterationlevels));
        return workflowContextBuilder.build();
    }

    private List<KogitoTypesProtobuf.NodeInstance> buildNodeInstances(List<NodeInstance> nodeInstances) {
        Comparator comparator = (o1, o2) -> ((KogitoNodeInstance)o1).getStringId().compareTo(((KogitoNodeInstance)o2).getStringId());
        Collections.sort(nodeInstances, comparator);
        ArrayList<KogitoTypesProtobuf.NodeInstance> nodeInstancesProtobuf = new ArrayList<KogitoTypesProtobuf.NodeInstance>();
        for (NodeInstance nodeInstance : nodeInstances) {
            KogitoTypesProtobuf.NodeInstance.Builder node = KogitoTypesProtobuf.NodeInstance.newBuilder().setId(((KogitoNodeInstance)nodeInstance).getStringId()).setNodeId(nodeInstance.getNodeId().toExternalFormat()).setLevel(((org.jbpm.workflow.instance.NodeInstance)nodeInstance).getLevel());
            Date triggerDate = ((org.jbpm.workflow.instance.NodeInstance)nodeInstance).getTriggerTime();
            if (triggerDate != null) {
                node.setTriggerDate(triggerDate.getTime());
            }
            node.setSla(this.buildSLAContext(((org.jbpm.workflow.instance.NodeInstance)nodeInstance).getSlaCompliance(), ((org.jbpm.workflow.instance.NodeInstance)nodeInstance).getSlaDueDate(), ((org.jbpm.workflow.instance.NodeInstance)nodeInstance).getSlaTimerId()));
            node.setContent(this.buildNodeInstanceContent(nodeInstance));
            nodeInstancesProtobuf.add(node.build());
        }
        return nodeInstancesProtobuf;
    }

    private Any buildNodeInstanceContent(NodeInstance nodeInstance) {
        KogitoProcessRuntime runtime = ((AbstractProcess)this.context.get(MarshallerContextName.MARSHALLER_PROCESS)).getProcessRuntime();
        Arrays.stream(this.listeners).forEach(e -> e.beforeMarshallNode(runtime, (KogitoNodeInstance)nodeInstance));
        NodeInstanceWriter writer = this.context.findNodeInstanceWriter(nodeInstance);
        if (writer == null) {
            throw new IllegalArgumentException("Unknown node instance type: " + nodeInstance);
        }
        LOGGER.debug("Node writer {}", (Object)writer);
        GeneratedMessageV3.Builder<?> builder = writer.write(this.context, nodeInstance);
        LOGGER.debug("Node instance being writing {}", (Object)nodeInstance);
        Descriptors.FieldDescriptor fieldContext = this.getContextField(builder);
        if (fieldContext != null) {
            LOGGER.debug("Node instance context being writing {}", (Object)nodeInstance);
            builder.setField(fieldContext, (Object)this.buildWorkflowContext((NodeInstanceContainer)((ContextableInstance)((ContextInstanceContainer)nodeInstance))));
        }
        return Any.pack((Message)builder.build());
    }

    public Descriptors.FieldDescriptor getContextField(GeneratedMessageV3.Builder<?> builder) {
        for (Descriptors.FieldDescriptor field : builder.getDescriptorForType().getFields()) {
            if (!"context".equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    private <T extends NodeInstanceContainer & ContextInstanceContainer> KogitoTypesProtobuf.WorkflowContext buildWorkflowContext(T nodeInstance) {
        ArrayList<NodeInstance> nodeInstances = new ArrayList<NodeInstance>(nodeInstance.getNodeInstances());
        List exclusiveGroupInstances = ((ContextInstanceContainer)nodeInstance).getContextInstances("ExclusiveGroup");
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)((ContextableInstance)nodeInstance).getContextInstance("VariableScope");
        ArrayList<Map.Entry<String, Object>> variables = variableScopeInstance != null ? new ArrayList<Map.Entry<String, Object>>(variableScopeInstance.getVariables().entrySet()) : Collections.emptyList();
        ArrayList<Map.Entry<String, Integer>> iterationlevels = new ArrayList<Map.Entry<String, Integer>>(nodeInstance.getIterationLevels().entrySet());
        return this.buildWorkflowContext(nodeInstances, exclusiveGroupInstances, variables, iterationlevels);
    }

    private List<KogitoTypesProtobuf.NodeInstanceGroup> buildGroups(List<ContextInstance> exclusiveGroupInstances) {
        if (exclusiveGroupInstances == null) {
            return Collections.emptyList();
        }
        ArrayList<KogitoTypesProtobuf.NodeInstanceGroup> groupProtobuf = new ArrayList<KogitoTypesProtobuf.NodeInstanceGroup>();
        for (ContextInstance contextInstance : exclusiveGroupInstances) {
            KogitoTypesProtobuf.NodeInstanceGroup.Builder exclusiveNodeInstanceGroup = KogitoTypesProtobuf.NodeInstanceGroup.newBuilder();
            ExclusiveGroupInstance exclusiveGroupInstance = (ExclusiveGroupInstance)contextInstance;
            Collection groupNodeInstances = exclusiveGroupInstance.getNodeInstances();
            for (KogitoNodeInstance nodeInstance : groupNodeInstances) {
                exclusiveNodeInstanceGroup.addGroupNodeInstanceId(nodeInstance.getStringId());
            }
            groupProtobuf.add(exclusiveNodeInstanceGroup.build());
        }
        return groupProtobuf;
    }

    private List<KogitoTypesProtobuf.IterationLevel> buildIterationLevels(List<Map.Entry<String, Integer>> iterationlevels) {
        Comparator comparator = (o1, o2) -> ((String)o1.getKey()).compareTo((String)o2.getKey());
        Collections.sort(iterationlevels, comparator);
        ArrayList<KogitoTypesProtobuf.IterationLevel> levelsProtobuf = new ArrayList<KogitoTypesProtobuf.IterationLevel>();
        for (Map.Entry<String, Integer> level : iterationlevels) {
            if (level.getValue() == null) continue;
            KogitoTypesProtobuf.IterationLevel levelProtobuf = KogitoTypesProtobuf.IterationLevel.newBuilder().setId(level.getKey()).setLevel(level.getValue()).build();
            levelsProtobuf.add(levelProtobuf);
        }
        return levelsProtobuf;
    }
}

