/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.flow.serialization.impl.marshallers;

import com.google.protobuf.Any;
import com.google.protobuf.Message;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jbpm.flow.serialization.ObjectMarshallerStrategy;
import org.jbpm.flow.serialization.ProcessInstanceMarshallerException;
import org.jbpm.flow.serialization.protobuf.KogitoTypesProtobuf;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ProtobufDocumentNodeMessageMarshaller
implements ObjectMarshallerStrategy {
    @Override
    public boolean acceptForMarshalling(Object value) {
        return value instanceof Document;
    }

    @Override
    public boolean acceptForUnmarshalling(Any value) {
        return value.is(KogitoTypesProtobuf.Document.class);
    }

    @Override
    public Any marshall(Object unmarshalled) {
        try {
            KogitoTypesProtobuf.Document.Builder builder = KogitoTypesProtobuf.Document.newBuilder();
            Document document = (Document)unmarshalled;
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer trans = tf.newTransformer();
            StringWriter sw = new StringWriter();
            trans.transform(new DOMSource(document), new StreamResult(sw));
            builder.setContent(sw.toString());
            return Any.pack((Message)builder.build());
        }
        catch (TransformerException e) {
            throw new ProcessInstanceMarshallerException("Error trying to marshalling a Document Node value", e);
        }
    }

    @Override
    public Object unmarshall(Any data) {
        try {
            KogitoTypesProtobuf.Document storedValue = (KogitoTypesProtobuf.Document)data.unpack(KogitoTypesProtobuf.Document.class);
            StringBuilder xmlStringBuilder = new StringBuilder(storedValue.getContent());
            ByteArrayInputStream input = new ByteArrayInputStream(xmlStringBuilder.toString().getBytes("UTF-8"));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setExpandEntityReferences(false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            return factory.newDocumentBuilder().parse(input);
        }
        catch (IOException | ParserConfigurationException | SAXException e1) {
            throw new ProcessInstanceMarshallerException("Error trying to unmarshalling a Document Node value", e1);
        }
    }
}

