/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.flow.serialization.impl.marshallers.state;

import com.google.protobuf.GeneratedMessageV3;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.jbpm.flow.serialization.MarshallerWriterContext;
import org.jbpm.flow.serialization.NodeInstanceWriter;
import org.jbpm.flow.serialization.protobuf.KogitoNodeInstanceContentsProtobuf;
import org.jbpm.workflow.instance.node.JoinInstance;
import org.kie.api.definition.process.WorkflowElementIdentifier;
import org.kie.api.runtime.process.NodeInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinNodeInstanceWriter
implements NodeInstanceWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JoinNodeInstanceWriter.class);

    @Override
    public boolean accept(NodeInstance value) {
        return value instanceof JoinInstance;
    }

    @Override
    public GeneratedMessageV3.Builder<?> write(MarshallerWriterContext context, NodeInstance value) {
        JoinInstance nodeInstance = (JoinInstance)value;
        KogitoNodeInstanceContentsProtobuf.JoinNodeInstanceContent.Builder joinBuilder = KogitoNodeInstanceContentsProtobuf.JoinNodeInstanceContent.newBuilder();
        Map triggers = nodeInstance.getTriggers();
        ArrayList keys = new ArrayList(triggers.keySet());
        Collections.sort(keys);
        for (WorkflowElementIdentifier key : keys) {
            LOGGER.info("marshalling join {}", (Object)key.toExternalFormat());
            joinBuilder.addTrigger(KogitoNodeInstanceContentsProtobuf.JoinNodeInstanceContent.JoinTrigger.newBuilder().setNodeId(key.toExternalFormat()).setCounter((Integer)triggers.get(key)).build());
        }
        return joinBuilder;
    }
}

