/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.flow.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jbpm.flow.serialization.MarshallerContext;
import org.jbpm.flow.serialization.MarshallerContextName;
import org.jbpm.flow.serialization.MarshallerReaderContext;
import org.jbpm.flow.serialization.MarshallerWriterContext;
import org.jbpm.flow.serialization.NodeInstanceReader;
import org.jbpm.flow.serialization.NodeInstanceWriter;
import org.jbpm.flow.serialization.ObjectMarshallerStrategy;
import org.jbpm.flow.serialization.ObjectMarshallerStrategyHelper;
import org.jbpm.flow.serialization.ProcessInstanceMarshaller;
import org.jbpm.flow.serialization.ProcessInstanceMarshallerException;
import org.jbpm.flow.serialization.ProcessInstanceMarshallerFactory;
import org.jbpm.flow.serialization.ProcessInstanceMarshallerListener;
import org.jbpm.flow.serialization.impl.ProtobufProcessInstanceMarshallerFactory;
import org.jbpm.util.JbpmClassLoaderUtil;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.impl.AbstractProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessInstanceMarshallerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceMarshallerService.class);
    private List<ObjectMarshallerStrategy> strats;
    private List<ProcessInstanceMarshallerListener> listeners = new ArrayList<ProcessInstanceMarshallerListener>();
    private Map<MarshallerContextName<Object>, Object> contextEntries;
    private ProcessInstanceMarshallerFactory processInstanceMarshallerFactory;
    private List<NodeInstanceReader> readers;
    private List<NodeInstanceWriter> writers;

    public static Builder newBuilder() {
        return new ProcessInstanceMarshallerService().new Builder();
    }

    private ProcessInstanceMarshallerService() {
        this.strats = new ArrayList<ObjectMarshallerStrategy>();
        this.readers = new ArrayList<NodeInstanceReader>();
        this.writers = new ArrayList<NodeInstanceWriter>();
        this.contextEntries = new HashMap<MarshallerContextName<Object>, Object>();
    }

    protected void setupEnvironment(MarshallerContext env) {
        env.set(MarshallerContextName.OBJECT_MARSHALLING_STRATEGIES, this.strats.toArray(new ObjectMarshallerStrategy[this.strats.size()]));
        for (Map.Entry<MarshallerContextName<Object>, Object> entry : this.contextEntries.entrySet()) {
            env.set(entry.getKey(), entry.getValue());
        }
    }

    public byte[] marshallProcessInstance(ProcessInstance<?> processInstance) {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            MarshallerWriterContext context = this.processInstanceMarshallerFactory.newWriterContext(baos);
            context.set(MarshallerContextName.MARSHALLER_PROCESS, processInstance.process());
            context.set(MarshallerContextName.MARSHALLER_INSTANCE_LISTENER, (ProcessInstanceMarshallerListener[])this.listeners.toArray(ProcessInstanceMarshallerListener[]::new));
            context.set(MarshallerContextName.MARSHALLER_NODE_INSTANCE_WRITER, (NodeInstanceWriter[])this.writers.toArray(NodeInstanceWriter[]::new));
            this.setupEnvironment(context);
            ProcessInstanceMarshaller marshaller = this.processInstanceMarshallerFactory.newKogitoProcessInstanceMarshaller();
            marshaller.writeProcessInstance(context, processInstance);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new ProcessInstanceMarshallerException("Error while marshalling process instance", e);
            }
        }
        baos.close();
        return byArray;
    }

    public ProcessInstance<?> unmarshallProcessInstance(byte[] data, Process<?> process, boolean readOnly) {
        ProcessInstance<?> processInstance;
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            MarshallerReaderContext context = this.processInstanceMarshallerFactory.newReaderContext(bais);
            context.set(MarshallerContextName.MARSHALLER_PROCESS, process);
            context.set(MarshallerContextName.MARSHALLER_INSTANCE_READ_ONLY, readOnly);
            context.set(MarshallerContextName.MARSHALLER_INSTANCE_LISTENER, (ProcessInstanceMarshallerListener[])this.listeners.toArray(ProcessInstanceMarshallerListener[]::new));
            context.set(MarshallerContextName.MARSHALLER_NODE_INSTANCE_READER, (NodeInstanceReader[])this.readers.toArray(NodeInstanceReader[]::new));
            this.setupEnvironment(context);
            ProcessInstanceMarshaller marshaller = this.processInstanceMarshallerFactory.newKogitoProcessInstanceMarshaller();
            processInstance = marshaller.readProcessInstance(context);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bais.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new ProcessInstanceMarshallerException("Error while unmarshalling process instance", e);
            }
        }
        bais.close();
        return processInstance;
    }

    public ProcessInstance<?> unmarshallProcessInstance(byte[] data, Process<?> process) {
        return this.unmarshallProcessInstance(data, process, false);
    }

    public ProcessInstance<?> unmarshallReadOnlyProcessInstance(byte[] data, Process<?> process) {
        return this.unmarshallProcessInstance(data, process, true);
    }

    public Consumer<AbstractProcessInstance<?>> createdReloadFunction(Supplier<byte[]> dataSupplier) {
        return processInstance -> {
            byte[] data = (byte[])dataSupplier.get();
            if (data == null) {
                LOGGER.warn("Process Instance {} cannot be found", (Object)processInstance.id());
            }
            try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
                MarshallerReaderContext context = this.processInstanceMarshallerFactory.newReaderContext(bais);
                context.set(MarshallerContextName.MARSHALLER_PROCESS, processInstance.process());
                context.set(MarshallerContextName.MARSHALLER_INSTANCE_LISTENER, (ProcessInstanceMarshallerListener[])this.listeners.toArray(ProcessInstanceMarshallerListener[]::new));
                context.set(MarshallerContextName.MARSHALLER_NODE_INSTANCE_READER, (NodeInstanceReader[])this.readers.toArray(NodeInstanceReader[]::new));
                this.setupEnvironment(context);
                ProcessInstanceMarshaller marshaller = this.processInstanceMarshallerFactory.newKogitoProcessInstanceMarshaller();
                marshaller.reloadProcessInstance(context, (ProcessInstance<?>)processInstance);
            }
            catch (Exception e) {
                LOGGER.warn("Process Instance {} cannot be reloaded", (Object)processInstance.id(), (Object)e);
            }
        };
    }

    public Function<byte[], ProcessInstance<?>> createUnmarshallFunction(Process<?> process, ProcessInstanceReadMode readMode) {
        return data -> this.unmarshallProcessInstance((byte[])data, process, readMode);
    }

    public ProcessInstance<?> unmarshallProcessInstance(byte[] data, Process<?> process, ProcessInstanceReadMode mode) {
        return this.unmarshallProcessInstance(data, process, mode.isReadOnly());
    }

    public class Builder {
        public Builder() {
            ProcessInstanceMarshallerService.this.processInstanceMarshallerFactory = new ProtobufProcessInstanceMarshallerFactory();
        }

        public Builder withProcessInstanceMarshallerFactory(ProcessInstanceMarshallerFactory factory) {
            ProcessInstanceMarshallerService.this.processInstanceMarshallerFactory = factory;
            return this;
        }

        public <T> Builder withContextEntries(Map<MarshallerContextName<T>, T> contextEntries) {
            for (Map.Entry<MarshallerContextName<T>, T> item : contextEntries.entrySet()) {
                ProcessInstanceMarshallerService.this.contextEntries.put(item.getKey(), item.getValue());
            }
            return this;
        }

        public <T> Builder withContextEntry(MarshallerContextName<T> key, T value) {
            if (value != null) {
                ProcessInstanceMarshallerService.this.contextEntries.put(key, value);
            }
            return this;
        }

        public Builder withDefaultListeners() {
            ServiceLoader<ProcessInstanceMarshallerListener> loader = ServiceLoader.load(ProcessInstanceMarshallerListener.class);
            for (ProcessInstanceMarshallerListener strategy : loader) {
                ProcessInstanceMarshallerService.this.listeners.add(strategy);
            }
            return this;
        }

        public Builder withDefaultObjectMarshallerStrategies() {
            ProcessInstanceMarshallerService.this.strats.addAll(List.of(ObjectMarshallerStrategyHelper.defaultStrategies()));
            ServiceLoader<NodeInstanceReader> readerLoader = ServiceLoader.load(NodeInstanceReader.class, JbpmClassLoaderUtil.findClassLoader());
            for (NodeInstanceReader reader : readerLoader) {
                ProcessInstanceMarshallerService.this.readers.add(reader);
            }
            ServiceLoader<NodeInstanceWriter> writerLoader = ServiceLoader.load(NodeInstanceWriter.class, JbpmClassLoaderUtil.findClassLoader());
            for (NodeInstanceWriter writer : writerLoader) {
                ProcessInstanceMarshallerService.this.writers.add(writer);
            }
            return this;
        }

        public Builder withListeners(ProcessInstanceMarshallerListener ... strategies) {
            for (ProcessInstanceMarshallerListener strategy : strategies) {
                ProcessInstanceMarshallerService.this.listeners.add(strategy);
            }
            return this;
        }

        public Builder withObjectMarshallerStrategies(ObjectMarshallerStrategy ... strategies) {
            for (ObjectMarshallerStrategy strategy : strategies) {
                ProcessInstanceMarshallerService.this.strats.add(strategy);
            }
            return this;
        }

        public ProcessInstanceMarshallerService build() {
            Collections.sort(ProcessInstanceMarshallerService.this.strats);
            Collections.sort(ProcessInstanceMarshallerService.this.readers);
            Collections.sort(ProcessInstanceMarshallerService.this.writers);
            return ProcessInstanceMarshallerService.this;
        }
    }
}

