/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.flow.serialization.impl;

import com.google.protobuf.Any;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import org.jbpm.flow.serialization.MarshallerContext;
import org.jbpm.flow.serialization.MarshallerContextName;
import org.jbpm.flow.serialization.ObjectMarshallerStrategy;
import org.jbpm.flow.serialization.ProcessInstanceMarshallerException;

public abstract class ProtobufAbstractMarshallerContext
implements MarshallerContext {
    private Map<MarshallerContextName<?>, Object> env = new HashMap();

    @Override
    public <T> T get(MarshallerContextName<T> key) {
        Object value = this.env.get(key);
        return (T)(value != null ? value : key.defaultValue());
    }

    @Override
    public <T> void set(MarshallerContextName<T> key, T value) {
        this.env.put(key, value);
    }

    @Override
    public ObjectMarshallerStrategy findObjectMarshallerStrategyFor(Object value) {
        return this.findMarshaller(value, (s, v) -> s.acceptForMarshalling(v));
    }

    @Override
    public ObjectMarshallerStrategy findObjectUnmarshallerStrategyFor(Any value) {
        return this.findMarshaller(value, (s, v) -> s.acceptForUnmarshalling((Any)v));
    }

    private ObjectMarshallerStrategy findMarshaller(Object value, BiPredicate<ObjectMarshallerStrategy, Object> type) {
        ObjectMarshallerStrategy[] objectMarshallerStrategies;
        for (ObjectMarshallerStrategy current : objectMarshallerStrategies = this.get(MarshallerContextName.OBJECT_MARSHALLING_STRATEGIES)) {
            if (!type.test(current, value)) continue;
            return current;
        }
        throw new ProcessInstanceMarshallerException("No marshaller found for class " + value.getClass().getName());
    }
}

