/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.flow.serialization.impl;

import com.google.protobuf.Any;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jbpm.flow.serialization.MarshallerContextName;
import org.jbpm.flow.serialization.MarshallerReaderContext;
import org.jbpm.flow.serialization.NodeInstanceReader;
import org.jbpm.flow.serialization.ProcessInstanceMarshallerListener;
import org.jbpm.flow.serialization.impl.ProtobufVariableReader;
import org.jbpm.flow.serialization.protobuf.KogitoProcessInstanceProtobuf;
import org.jbpm.flow.serialization.protobuf.KogitoTypesProtobuf;
import org.jbpm.flow.serialization.protobuf.ProtobufTypeRegistryFactory;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.ContextInstanceContainer;
import org.jbpm.process.instance.ContextableInstance;
import org.jbpm.process.instance.context.exclusive.ExclusiveGroupInstance;
import org.jbpm.process.instance.context.swimlane.SwimlaneContextInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.ruleflow.core.WorkflowElementIdentifierFactory;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstanceContainer;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcessInstance;
import org.kie.kogito.process.impl.AbstractProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufProcessInstanceReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtobufProcessInstanceReader.class);
    private RuleFlowProcessInstance ruleFlowProcessInstance;
    private MarshallerReaderContext context;
    private ProtobufVariableReader varReader;
    private ProcessInstanceMarshallerListener[] listeners;

    public ProtobufProcessInstanceReader(MarshallerReaderContext context) {
        this.context = context;
        this.ruleFlowProcessInstance = new RuleFlowProcessInstance();
        this.varReader = new ProtobufVariableReader(context);
        this.listeners = context.get(MarshallerContextName.MARSHALLER_INSTANCE_LISTENER);
        context.set(MarshallerContextName.MARSHALLER_PROCESS_INSTANCE, this.ruleFlowProcessInstance);
    }

    public RuleFlowProcessInstance read(InputStream input) throws IOException {
        KogitoProcessInstanceProtobuf.ProcessInstance processInstanceProtobuf;
        LOGGER.debug("read process");
        String format = this.context.get(MarshallerContextName.MARSHALLER_FORMAT);
        if (format != null && "json".equals(format)) {
            KogitoProcessInstanceProtobuf.ProcessInstance.Builder builder = KogitoProcessInstanceProtobuf.ProcessInstance.newBuilder();
            JsonFormat.parser().usingTypeRegistry(ProtobufTypeRegistryFactory.protobufTypeRegistryFactoryInstance().create()).ignoringUnknownFields().merge((Reader)new InputStreamReader(input), (Message.Builder)builder);
            processInstanceProtobuf = builder.build();
        } else {
            processInstanceProtobuf = KogitoProcessInstanceProtobuf.ProcessInstance.parseFrom(input);
        }
        return this.buildWorkflow(processInstanceProtobuf);
    }

    private RuleFlowProcessInstance buildWorkflow(KogitoProcessInstanceProtobuf.ProcessInstance processInstanceProtobuf) {
        RuleFlowProcessInstance processInstance = this.ruleFlowProcessInstance;
        processInstance.setProcessId(processInstanceProtobuf.getProcessId());
        processInstance.setProcessVersion(processInstanceProtobuf.getProcessVersion());
        processInstance.setInternalProcess(((AbstractProcess)this.context.get(MarshallerContextName.MARSHALLER_PROCESS)).get());
        processInstance.setId(processInstanceProtobuf.getId());
        processInstance.setState(processInstanceProtobuf.getState());
        processInstance.setSignalCompletion(processInstanceProtobuf.getSignalCompletion());
        if (processInstanceProtobuf.hasStartDate()) {
            processInstance.setStartDate(new Date(processInstanceProtobuf.getStartDate()));
        }
        if (processInstanceProtobuf.hasDescription()) {
            processInstance.setDescription(processInstanceProtobuf.getDescription());
        }
        if (processInstanceProtobuf.hasDeploymentId()) {
            processInstance.setDeploymentId(processInstanceProtobuf.getDeploymentId());
        }
        for (Object completedNodeId : processInstanceProtobuf.getCompletedNodeIdsList()) {
            processInstance.addCompletedNodeId((String)completedNodeId);
        }
        if (processInstanceProtobuf.hasBusinessKey()) {
            processInstance.setCorrelationKey(processInstanceProtobuf.getBusinessKey());
        }
        if (processInstanceProtobuf.hasSla()) {
            KogitoTypesProtobuf.SLAContext slaContext = processInstanceProtobuf.getSla();
            if (slaContext.getSlaDueDate() > 0L) {
                processInstance.internalSetSlaDueDate(new Date(slaContext.getSlaDueDate()));
            }
            if (slaContext.hasSlaTimerId()) {
                processInstance.internalSetSlaTimerId(slaContext.getSlaTimerId());
            }
            if (slaContext.hasSlaCompliance()) {
                processInstance.internalSetSlaCompliance(slaContext.getSlaCompliance());
            }
        }
        if (processInstanceProtobuf.hasCancelTimerId()) {
            processInstance.internalSetCancelTimerId(processInstanceProtobuf.getCancelTimerId());
        }
        if (processInstanceProtobuf.hasParentProcessInstanceId()) {
            processInstance.setParentProcessInstanceId(processInstanceProtobuf.getParentProcessInstanceId());
        }
        if (processInstanceProtobuf.hasRootProcessInstanceId()) {
            processInstance.setRootProcessInstanceId(processInstanceProtobuf.getRootProcessInstanceId());
        }
        if (processInstanceProtobuf.hasRootProcessId()) {
            processInstance.setRootProcessId(processInstanceProtobuf.getRootProcessId());
        }
        if (processInstanceProtobuf.hasErrorNodeId()) {
            processInstance.internalSetErrorNodeId(processInstanceProtobuf.getErrorNodeId());
        }
        if (processInstanceProtobuf.hasErrorNodeInstanceId()) {
            processInstance.internalSetErrorNodeInstanceId(processInstanceProtobuf.getErrorNodeInstanceId());
        }
        if (processInstanceProtobuf.hasErrorMessage()) {
            processInstance.internalSetErrorMessage(processInstanceProtobuf.getErrorMessage());
        }
        if (processInstanceProtobuf.hasReferenceId()) {
            processInstance.setReferenceId(processInstanceProtobuf.getReferenceId());
        }
        if (processInstanceProtobuf.getSwimlaneContextCount() > 0) {
            SwimlaneContextInstance swimlaneContextInstance = (SwimlaneContextInstance)processInstance.getContextInstance("SwimlaneScope");
            for (KogitoTypesProtobuf.SwimlaneContext _swimlane : processInstanceProtobuf.getSwimlaneContextList()) {
                swimlaneContextInstance.setActorId(_swimlane.getSwimlane(), _swimlane.getActorId());
            }
        }
        if (processInstanceProtobuf.getHeadersList() != null) {
            processInstance.setHeaders(processInstanceProtobuf.getHeadersList().stream().collect(Collectors.toMap(KogitoProcessInstanceProtobuf.HeaderEntry::getKey, KogitoProcessInstanceProtobuf.HeaderEntry::getValueList)));
        }
        KogitoTypesProtobuf.WorkflowContext workflowContext = processInstanceProtobuf.getContext();
        this.buildWorkflowContext(processInstance, workflowContext);
        KogitoProcessRuntime runtime = ((AbstractProcess)this.context.get(MarshallerContextName.MARSHALLER_PROCESS)).getProcessRuntime();
        Arrays.stream(this.listeners).forEach(e -> e.afterUnmarshallProcess(runtime, (KogitoWorkflowProcessInstance)processInstance));
        return processInstance;
    }

    private void setCommonNodeInstanceData(RuleFlowProcessInstance processInstance, KogitoNodeInstanceContainer parentContainer, KogitoTypesProtobuf.NodeInstance nodeInstanceProtobuf, NodeInstanceImpl nodeInstanceImpl) {
        if (nodeInstanceImpl.getStringId() == null) {
            nodeInstanceImpl.setId(nodeInstanceProtobuf.getId());
        }
        if (nodeInstanceImpl.getNodeId() == null) {
            nodeInstanceImpl.setNodeId(WorkflowElementIdentifierFactory.fromExternalFormat((String)nodeInstanceProtobuf.getNodeId()));
        }
        if (nodeInstanceImpl.getNodeInstanceContainer() == null) {
            nodeInstanceImpl.setNodeInstanceContainer(parentContainer);
        }
        if (nodeInstanceImpl.getProcessInstance() == null) {
            nodeInstanceImpl.setProcessInstance((WorkflowProcessInstance)processInstance);
        }
        if (nodeInstanceProtobuf.hasRetrigger()) {
            nodeInstanceImpl.internalSetRetrigger(nodeInstanceProtobuf.getRetrigger());
        }
        nodeInstanceImpl.setLevel(nodeInstanceProtobuf.getLevel() == 0 ? 1 : nodeInstanceProtobuf.getLevel());
    }

    protected NodeInstanceImpl buildNodeInstance(KogitoTypesProtobuf.NodeInstance nodeInstance, KogitoNodeInstanceContainer parent) {
        try {
            Any nodeContentProtobuf = nodeInstance.getContent();
            NodeInstanceReader reader = this.context.findNodeInstanceReader(nodeContentProtobuf);
            if (reader == null) {
                throw new IllegalArgumentException("Unknown node instance " + nodeInstance);
            }
            LOGGER.debug("Node reader {}", (Object)reader);
            NodeInstanceImpl result = (NodeInstanceImpl)reader.read(this.context, nodeContentProtobuf);
            this.setCommonNodeInstanceData(this.ruleFlowProcessInstance, parent, nodeInstance, result);
            LOGGER.debug("Node {} content {}", reader.type(), (Object)nodeContentProtobuf);
            GeneratedMessageV3 content = (GeneratedMessageV3)nodeContentProtobuf.unpack(reader.type());
            LOGGER.debug("Node instance being reading {}", (Object)result);
            Descriptors.FieldDescriptor fieldDescriptor = this.getContextField(content);
            if (fieldDescriptor != null) {
                LOGGER.debug("Node instance context being reading {}", (Object)result);
                KogitoTypesProtobuf.WorkflowContext workflowContext = (KogitoTypesProtobuf.WorkflowContext)content.getField(fieldDescriptor);
                this.buildWorkflowContext((NodeInstanceContainer)((ContextableInstance)((ContextInstanceContainer)result)), workflowContext);
            }
            KogitoTypesProtobuf.SLAContext slaNodeInstanceContext = nodeInstance.getSla();
            result.internalSetSlaCompliance(slaNodeInstanceContext.getSlaCompliance());
            if (slaNodeInstanceContext.getSlaDueDate() > 0L) {
                result.internalSetSlaDueDate(new Date(slaNodeInstanceContext.getSlaDueDate()));
            }
            result.internalSetSlaTimerId(slaNodeInstanceContext.getSlaTimerId());
            if (nodeInstance.hasTriggerDate()) {
                result.internalSetTriggerTime(new Date(nodeInstance.getTriggerDate()));
            }
            NodeInstanceImpl kogitoNodeInstance = result;
            KogitoProcessRuntime runtime = ((AbstractProcess)this.context.get(MarshallerContextName.MARSHALLER_PROCESS)).getProcessRuntime();
            Arrays.stream(this.listeners).forEach(arg_0 -> ProtobufProcessInstanceReader.lambda$buildNodeInstance$1(runtime, (KogitoNodeInstance)kogitoNodeInstance, arg_0));
            return result;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot read node instance content", e);
        }
    }

    public Descriptors.FieldDescriptor getContextField(GeneratedMessageV3 message) {
        for (Descriptors.FieldDescriptor field : message.getDescriptorForType().getFields()) {
            if (!"context".equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    private <T extends NodeInstanceContainer & ContextInstanceContainer> void buildWorkflowContext(T container, KogitoTypesProtobuf.WorkflowContext workflowContext) {
        if (workflowContext.getNodeInstanceCount() > 0) {
            for (KogitoTypesProtobuf.NodeInstance nodeInstanceProtobuf : workflowContext.getNodeInstanceList()) {
                this.buildNodeInstance(nodeInstanceProtobuf, (KogitoNodeInstanceContainer)container);
            }
        }
        ((ContextInstanceContainer)container).addContextInstance("VariableScope", (ContextInstance)new VariableScopeInstance());
        if (workflowContext.getVariableCount() > 0) {
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)((ContextableInstance)container).getContextInstance("VariableScope");
            this.varReader.buildVariables(workflowContext.getVariableList()).forEach(v -> variableScopeInstance.internalSetVariable(v.getName(), v.getValue()));
        }
        if (workflowContext.getIterationLevelsCount() > 0) {
            container.getIterationLevels().putAll(this.buildIterationLevels(workflowContext.getIterationLevelsList()));
        }
        for (KogitoTypesProtobuf.NodeInstanceGroup group : workflowContext.getExclusiveGroupList()) {
            Function<String, KogitoNodeInstance> finder = nodeInstanceId -> container.getNodeInstance(nodeInstanceId, true);
            ((ContextInstanceContainer)container).addContextInstance("ExclusiveGroup", (ContextInstance)this.buildExclusiveGroupInstance(group, finder));
        }
    }

    private ExclusiveGroupInstance buildExclusiveGroupInstance(KogitoTypesProtobuf.NodeInstanceGroup group, Function<String, KogitoNodeInstance> finder) {
        ExclusiveGroupInstance exclusiveGroupInstance = new ExclusiveGroupInstance();
        for (String nodeInstanceId : group.getGroupNodeInstanceIdList()) {
            KogitoNodeInstance kogitoNodeInstance = finder.apply(nodeInstanceId);
            if (kogitoNodeInstance == null) {
                throw new IllegalArgumentException("Could not find node instance when deserializing exclusive group instance: " + nodeInstanceId);
            }
            exclusiveGroupInstance.addNodeInstance(kogitoNodeInstance);
        }
        return exclusiveGroupInstance;
    }

    private Map<String, Integer> buildIterationLevels(List<KogitoTypesProtobuf.IterationLevel> iterationLevel) {
        Function<KogitoTypesProtobuf.IterationLevel, String> mapKey = KogitoTypesProtobuf.IterationLevel::getId;
        Function<KogitoTypesProtobuf.IterationLevel, Integer> mapValue = KogitoTypesProtobuf.IterationLevel::getLevel;
        return iterationLevel.stream().collect(Collectors.toMap(mapKey, mapValue));
    }

    private static /* synthetic */ void lambda$buildNodeInstance$1(KogitoProcessRuntime runtime, KogitoNodeInstance kogitoNodeInstance, ProcessInstanceMarshallerListener e) {
        e.afterUnmarshallNode(runtime, kogitoNodeInstance);
    }
}

