/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.flow.serialization.impl.marshallers;

import com.google.protobuf.Any;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import org.jbpm.flow.serialization.ObjectMarshallerStrategy;
import org.jbpm.flow.serialization.ProcessInstanceMarshallerException;

public class ProtobufDoubleMarshallerStrategy
implements ObjectMarshallerStrategy {
    @Override
    public boolean acceptForMarshalling(Object value) {
        return Double.class.equals(value.getClass());
    }

    @Override
    public boolean acceptForUnmarshalling(Any value) {
        return value.is(DoubleValue.class);
    }

    @Override
    public Any marshall(Object unmarshalled) {
        return Any.pack((Message)DoubleValue.of((double)((Double)unmarshalled)));
    }

    @Override
    public Object unmarshall(Any data) {
        try {
            DoubleValue storedValue = (DoubleValue)data.unpack(DoubleValue.class);
            return storedValue.getValue();
        }
        catch (InvalidProtocolBufferException e1) {
            throw new ProcessInstanceMarshallerException("Error trying to unmarshalling a double value", e1);
        }
    }
}

