/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.flow.serialization.impl.marshallers;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import org.jbpm.flow.serialization.ObjectMarshallerStrategy;
import org.jbpm.flow.serialization.ProcessInstanceMarshallerException;

public class ProtobufObjectMarshallerStrategy
implements ObjectMarshallerStrategy {
    @Override
    public Integer order() {
        return 1;
    }

    @Override
    public boolean acceptForMarshalling(Object value) {
        return true;
    }

    @Override
    public boolean acceptForUnmarshalling(Any value) {
        return value.is(BytesValue.class);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Any marshall(Object unmarshalled) {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            Any any;
            try (ObjectOutputStream out = new ObjectOutputStream(stream);){
                out.writeObject(unmarshalled);
                any = Any.pack((Message)BytesValue.of((ByteString)ByteString.copyFrom((byte[])stream.toByteArray())));
            }
            return any;
        }
        catch (IOException e) {
            throw new ProcessInstanceMarshallerException("Not possible to unmarshall value: " + unmarshalled, e);
        }
    }

    @Override
    public Object unmarshall(Any data) {
        try {
            BytesValue storedValue = (BytesValue)data.unpack(BytesValue.class);
            if (ByteString.EMPTY.equals((Object)storedValue.getValue())) {
                return null;
            }
            return this.readObject(storedValue.getValue().toByteArray());
        }
        catch (InvalidProtocolBufferException e1) {
            throw new ProcessInstanceMarshallerException("Unexpected error during protobuf object unmarshalling", e1);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Object readObject(byte[] data) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(data);){
            Object object;
            try (ObjectInputStream ois = new ObjectInputStream(is){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    try {
                        return Class.forName(desc.getName(), false, Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException ex) {
                        return super.resolveClass(desc);
                    }
                }
            };){
                object = ois.readObject();
            }
            return object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new ProcessInstanceMarshallerException("Unexpected error while trying to read object", e);
        }
    }
}

