/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.flow.serialization.impl.marshallers.state;

import com.google.protobuf.Any;
import com.google.protobuf.GeneratedMessageV3;
import java.util.HashMap;
import org.jbpm.flow.serialization.MarshallerReaderContext;
import org.jbpm.flow.serialization.NodeInstanceReader;
import org.jbpm.flow.serialization.ProcessInstanceMarshallerException;
import org.jbpm.flow.serialization.protobuf.KogitoNodeInstanceContentsProtobuf;
import org.jbpm.ruleflow.core.WorkflowElementIdentifierFactory;
import org.jbpm.workflow.instance.node.JoinInstance;
import org.kie.api.definition.process.WorkflowElementIdentifier;
import org.kie.api.runtime.process.NodeInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinNodeInstanceReader
implements NodeInstanceReader {
    private static Logger LOGGER = LoggerFactory.getLogger(JoinNodeInstanceReader.class);

    @Override
    public boolean accept(Any value) {
        return value.is(KogitoNodeInstanceContentsProtobuf.JoinNodeInstanceContent.class);
    }

    @Override
    public NodeInstance read(MarshallerReaderContext context, Any value) {
        try {
            KogitoNodeInstanceContentsProtobuf.JoinNodeInstanceContent content = (KogitoNodeInstanceContentsProtobuf.JoinNodeInstanceContent)value.unpack(KogitoNodeInstanceContentsProtobuf.JoinNodeInstanceContent.class);
            JoinInstance nodeInstance = new JoinInstance();
            if (content.getTriggerCount() > 0) {
                HashMap<WorkflowElementIdentifier, Integer> triggers = new HashMap<WorkflowElementIdentifier, Integer>();
                for (KogitoNodeInstanceContentsProtobuf.JoinNodeInstanceContent.JoinTrigger _join : content.getTriggerList()) {
                    LOGGER.debug("unmarshalling join {}", (Object)_join.getNodeId());
                    triggers.put(WorkflowElementIdentifierFactory.fromExternalFormat((String)_join.getNodeId()), _join.getCounter());
                }
                nodeInstance.internalSetTriggers(triggers);
            }
            return nodeInstance;
        }
        catch (Exception e) {
            throw new ProcessInstanceMarshallerException(e);
        }
    }

    @Override
    public Class<? extends GeneratedMessageV3> type() {
        return KogitoNodeInstanceContentsProtobuf.JoinNodeInstanceContent.class;
    }
}

