/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.flow.serialization.impl.marshallers.state;

import com.google.protobuf.Any;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.jbpm.flow.serialization.MarshallerContextName;
import org.jbpm.flow.serialization.MarshallerReaderContext;
import org.jbpm.flow.serialization.NodeInstanceReader;
import org.jbpm.flow.serialization.ProcessInstanceMarshallerException;
import org.jbpm.flow.serialization.impl.ProtobufVariableReader;
import org.jbpm.flow.serialization.protobuf.KogitoNodeInstanceContentsProtobuf;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.process.workitems.InternalKogitoWorkItem;
import org.kie.kogito.process.workitems.impl.KogitoWorkItemImpl;

public class WorkItemNodeInstanceReader
implements NodeInstanceReader {
    @Override
    public boolean accept(Any value) {
        return value.is(KogitoNodeInstanceContentsProtobuf.WorkItemNodeInstanceContent.class);
    }

    @Override
    public Class<? extends GeneratedMessageV3> type() {
        return KogitoNodeInstanceContentsProtobuf.WorkItemNodeInstanceContent.class;
    }

    @Override
    public NodeInstance read(MarshallerReaderContext context, Any value) {
        try {
            ProtobufVariableReader varReader = new ProtobufVariableReader(context);
            KogitoNodeInstanceContentsProtobuf.WorkItemNodeInstanceContent content = (KogitoNodeInstanceContentsProtobuf.WorkItemNodeInstanceContent)value.unpack(KogitoNodeInstanceContentsProtobuf.WorkItemNodeInstanceContent.class);
            WorkItemNodeInstance nodeInstance = this.instanceWorkItem();
            RuleFlowProcessInstance ruleFlowProcessInstance = context.get(MarshallerContextName.MARSHALLER_PROCESS_INSTANCE);
            nodeInstance.internalSetWorkItemId(content.getWorkItemId());
            InternalKogitoWorkItem workItem = nodeInstance.getWorkItem();
            workItem.setId(content.getWorkItemId());
            workItem.setProcessInstanceId(ruleFlowProcessInstance.getStringId());
            workItem.setName(content.getName());
            workItem.setState(content.getState());
            workItem.setDeploymentId(ruleFlowProcessInstance.getDeploymentId());
            workItem.setProcessInstance((KogitoProcessInstance)ruleFlowProcessInstance);
            workItem.setPhaseId(content.getPhaseId());
            workItem.setPhaseStatus(content.getPhaseStatus());
            workItem.setStartDate(new Date(content.getStartDate()));
            if (content.hasExternalReferenceId()) {
                workItem.setExternalReferenceId(content.getExternalReferenceId());
            }
            if (content.hasActualOwner()) {
                workItem.setActualOwner(content.getActualOwner());
            }
            if (content.getCompleteDate() > 0L) {
                workItem.setCompleteDate(new Date(content.getCompleteDate()));
            }
            if (content.getTimerInstanceIdCount() > 0) {
                nodeInstance.internalSetTimerInstances(new ArrayList(content.getTimerInstanceIdList()));
            }
            if (!content.getTimerInstanceReferenceMap().isEmpty()) {
                nodeInstance.internalSetTimerInstancesReference(new HashMap<String, String>(content.getTimerInstanceReferenceMap()));
            }
            nodeInstance.internalSetProcessInstanceId(content.getErrorHandlingProcessInstanceId());
            varReader.buildVariables(content.getVariableList()).forEach(var -> nodeInstance.getWorkItem().getParameters().put(var.getName(), var.getValue()));
            varReader.buildVariables(content.getResultList()).forEach(var -> nodeInstance.getWorkItem().getResults().put(var.getName(), var.getValue()));
            return nodeInstance;
        }
        catch (InvalidProtocolBufferException ex) {
            throw new ProcessInstanceMarshallerException("cannot unpack node instance", ex);
        }
    }

    private WorkItemNodeInstance instanceWorkItem() {
        WorkItemNodeInstance nodeInstance = new WorkItemNodeInstance();
        KogitoWorkItemImpl workItem = new KogitoWorkItemImpl();
        workItem.setId(UUID.randomUUID().toString());
        nodeInstance.internalSetWorkItem((InternalKogitoWorkItem)workItem);
        return nodeInstance;
    }
}

