/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.svg;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.util.XMLResourceDescriptor;
import org.kie.kogito.svg.ProcessSVGException;
import org.kie.kogito.svg.processor.SVGProcessor;
import org.kie.kogito.svg.processor.SVGProcessorFactory;
import org.w3c.dom.Document;

public class SVGImageProcessor {
    private SVGProcessor svgProcessor;

    public SVGImageProcessor(InputStream svg) {
        try {
            String parser = XMLResourceDescriptor.getXMLParserClassName();
            SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
            factory.setValidating(false);
            Document svgDocument = factory.createDocument("http://jbpm.org", svg);
            this.svgProcessor = new SVGProcessorFactory().create(svgDocument);
            this.svgProcessor.processNodes(svgDocument.getChildNodes());
        }
        catch (IOException e) {
            throw new ProcessSVGException("Could not parse svg", e);
        }
    }

    public static String transform(InputStream svg, List<String> completed, List<String> active) {
        return SVGImageProcessor.transform(svg, completed, active, null, "#C0C0C0", "#030303", "#FF0000");
    }

    public static String transform(InputStream svg, List<String> completed, List<String> active, Map<String, String> subProcessLinks) {
        return SVGImageProcessor.transform(svg, completed, active, subProcessLinks, "#C0C0C0", "#030303", "#FF0000");
    }

    public static String transform(InputStream svg, List<String> completed, List<String> active, Map<String, String> subProcessLinks, String completedNodeColor, String completedNodeBorderColor, String activeNodeBorderColor) {
        SVGProcessor processor = new SVGImageProcessor(svg).getProcessor();
        for (String string : completed) {
            if (active.contains(string)) continue;
            processor.defaultCompletedTransformation(string, completedNodeColor, completedNodeBorderColor);
        }
        for (String string : active) {
            processor.defaultActiveTransformation(string, activeNodeBorderColor);
        }
        if (subProcessLinks != null) {
            for (Map.Entry entry : subProcessLinks.entrySet()) {
                processor.defaultSubProcessLinkTransformation((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return processor.getSVG();
    }

    public SVGProcessor getProcessor() {
        return this.svgProcessor;
    }
}

