/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.svg.rest;

import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.kie.kogito.svg.ProcessSvgService;

@ApplicationScoped
@Path(value="/svg")
public class ProcessSvgResource {
    @Inject
    ProcessSvgService service;

    @GET
    @Path(value="processes/{processId}")
    @Produces(value={"image/svg+xml"})
    public Response getProcessSvg(@PathParam(value="processId") String processId) {
        Optional processSvg = this.service.getProcessSvg(processId);
        if (processSvg.isPresent()) {
            return Response.ok(processSvg.get()).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="processes/{processId}/instances/{processInstanceId}")
    @Produces(value={"image/svg+xml"})
    public Response getExecutionPathByProcessInstanceId(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId) {
        Optional processInstanceSvg = this.service.getProcessInstanceSvg(processId, processInstanceId);
        if (processInstanceSvg.isPresent()) {
            return Response.ok(processInstanceSvg.get()).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Inject
    protected void setProcessSvgService(ProcessSvgService service) {
        this.service = service;
    }
}

