/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.workitems.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.kie.kogito.Application;
import org.kie.kogito.internal.process.workitem.KogitoWorkItem;
import org.kie.kogito.internal.process.workitem.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.workitem.KogitoWorkItemManager;
import org.kie.kogito.internal.process.workitem.Policy;
import org.kie.kogito.internal.process.workitem.WorkItemLifeCycle;
import org.kie.kogito.internal.process.workitem.WorkItemLifeCyclePhase;
import org.kie.kogito.internal.process.workitem.WorkItemPhaseState;
import org.kie.kogito.internal.process.workitem.WorkItemTerminationType;
import org.kie.kogito.internal.process.workitem.WorkItemTransition;
import org.kie.kogito.process.workitems.impl.DefaultWorkItemLifeCycle;
import org.kie.kogito.process.workitems.impl.DefaultWorkItemLifeCyclePhase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultKogitoWorkItemHandler
implements KogitoWorkItemHandler {
    public static final String TRANSITION_COMPLETE = "complete";
    public static final String TRANSITION_ABORT = "abort";
    public static final String TRANSITION_ACTIVATE = "activate";
    public static final String TRANSITION_SKIP = "skip";
    public static final WorkItemPhaseState INITIALIZED = WorkItemPhaseState.initialized();
    public static final WorkItemPhaseState COMPLETED = WorkItemPhaseState.of((String)"Completed", (WorkItemTerminationType)WorkItemTerminationType.COMPLETE);
    public static final WorkItemPhaseState ABORTED = WorkItemPhaseState.of((String)"Aborted", (WorkItemTerminationType)WorkItemTerminationType.ABORT);
    public static final WorkItemPhaseState ACTIVATED = WorkItemPhaseState.of((String)"Activated");
    private static Logger LOG = LoggerFactory.getLogger(DefaultKogitoWorkItemHandler.class);
    protected Application application;
    protected WorkItemLifeCycle workItemLifeCycle;

    public DefaultKogitoWorkItemHandler(WorkItemLifeCycle workItemLifeCycle) {
        this.workItemLifeCycle = workItemLifeCycle;
    }

    public DefaultKogitoWorkItemHandler() {
        this.workItemLifeCycle = this.initialize();
    }

    public WorkItemLifeCycle initialize() {
        DefaultWorkItemLifeCyclePhase complete = new DefaultWorkItemLifeCyclePhase(TRANSITION_COMPLETE, ACTIVATED, COMPLETED, this::completeWorkItemHandler);
        DefaultWorkItemLifeCyclePhase abort = new DefaultWorkItemLifeCyclePhase(TRANSITION_ABORT, ACTIVATED, ABORTED, this::abortWorkItemHandler);
        DefaultWorkItemLifeCyclePhase active = new DefaultWorkItemLifeCyclePhase(TRANSITION_ACTIVATE, INITIALIZED, ACTIVATED, this::activateWorkItemHandler);
        DefaultWorkItemLifeCyclePhase skip = new DefaultWorkItemLifeCyclePhase(TRANSITION_SKIP, ACTIVATED, COMPLETED, this::skipWorkItemHandler);
        return new DefaultWorkItemLifeCycle(active, skip, abort, complete);
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public Application getApplication() {
        return this.application;
    }

    public WorkItemTransition startingTransition(Map<String, Object> data, Policy ... policies) {
        return this.workItemLifeCycle.newTransition(TRANSITION_ACTIVATE, null, data, policies);
    }

    public WorkItemTransition abortTransition(String phaseStatus, Policy ... policies) {
        return this.workItemLifeCycle.newTransition(TRANSITION_ABORT, phaseStatus, Collections.emptyMap(), policies);
    }

    public WorkItemTransition completeTransition(String phaseStatus, Map<String, Object> data, Policy ... policies) {
        return this.workItemLifeCycle.newTransition(TRANSITION_COMPLETE, phaseStatus, data, policies);
    }

    public Optional<WorkItemTransition> transitionToPhase(KogitoWorkItemManager manager, KogitoWorkItem workItem, WorkItemTransition transition) {
        LOG.debug("workItem {} handled by {} transition {}", new Object[]{workItem, this.getName(), transition});
        try {
            return this.workItemLifeCycle.transitionTo(manager, (KogitoWorkItemHandler)this, workItem, transition);
        }
        catch (RuntimeException e) {
            LOG.info("error workItem {} handled by {} transition {} ", new Object[]{workItem, this.getName(), transition, e});
            throw e;
        }
    }

    public Set<String> allowedTransitions(String phaseStatus) {
        return this.workItemLifeCycle.allowedPhases(phaseStatus).stream().map(WorkItemLifeCyclePhase::id).collect(Collectors.toSet());
    }

    public WorkItemTransition newTransition(String phaseId, String phaseStatus, Map<String, Object> map, Policy ... policy) {
        return this.workItemLifeCycle.newTransition(phaseId, phaseStatus, map, policy);
    }

    public Optional<WorkItemTransition> activateWorkItemHandler(KogitoWorkItemManager manager, KogitoWorkItemHandler handler, KogitoWorkItem workitem, WorkItemTransition transition) {
        return Optional.empty();
    }

    public Optional<WorkItemTransition> completeWorkItemHandler(KogitoWorkItemManager manager, KogitoWorkItemHandler handler, KogitoWorkItem workitem, WorkItemTransition transition) {
        return Optional.empty();
    }

    public Optional<WorkItemTransition> abortWorkItemHandler(KogitoWorkItemManager manager, KogitoWorkItemHandler handler, KogitoWorkItem workitem, WorkItemTransition transition) {
        return Optional.empty();
    }

    public Optional<WorkItemTransition> skipWorkItemHandler(KogitoWorkItemManager manager, KogitoWorkItemHandler handler, KogitoWorkItem workitem, WorkItemTransition transition) {
        return Optional.empty();
    }
}

