/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.workitems.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.core.process.WorkItem;
import org.kie.internal.runtime.Closeable;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.internal.process.workitem.KogitoWorkItem;
import org.kie.kogito.internal.process.workitem.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.workitem.KogitoWorkItemHandlerNotFoundException;
import org.kie.kogito.internal.process.workitem.KogitoWorkItemManager;
import org.kie.kogito.internal.process.workitem.Policy;
import org.kie.kogito.internal.process.workitem.WorkItemNotFoundException;
import org.kie.kogito.internal.process.workitem.WorkItemTerminationType;
import org.kie.kogito.internal.process.workitem.WorkItemTransition;
import org.kie.kogito.process.workitems.InternalKogitoWorkItem;
import org.kie.kogito.process.workitems.InternalKogitoWorkItemManager;

public class KogitoDefaultWorkItemManager
implements InternalKogitoWorkItemManager {
    private Map<String, InternalKogitoWorkItem> workItems;
    private Map<String, KogitoWorkItemHandler> workItemHandlers;
    private KogitoProcessRuntime kruntime;

    public KogitoDefaultWorkItemManager(KogitoProcessRuntime kruntime) {
        this.kruntime = kruntime;
        this.workItems = new ConcurrentHashMap<String, InternalKogitoWorkItem>();
        this.workItemHandlers = new HashMap<String, KogitoWorkItemHandler>();
    }

    public void clear() {
        this.workItems.clear();
    }

    public void signalEvent(String type, Object event) {
        this.kruntime.signalEvent(type, event);
    }

    public void dispose() {
        if (this.workItemHandlers != null) {
            for (Map.Entry<String, KogitoWorkItemHandler> handlerEntry : this.workItemHandlers.entrySet()) {
                if (!(handlerEntry.getValue() instanceof Closeable)) continue;
                ((Closeable)handlerEntry.getValue()).close();
            }
        }
    }

    public <T> T updateWorkItem(String id, Function<KogitoWorkItem, T> updater, Policy ... policies) {
        KogitoWorkItem workItem = this.workItems.get(id);
        if (workItem == null) {
            throw new WorkItemNotFoundException(id);
        }
        Stream.of(policies).forEach(p -> p.enforce(workItem));
        return updater.apply(workItem);
    }

    public Collection<String> getHandlerIds() {
        return this.workItemHandlers.keySet();
    }

    public KogitoWorkItemHandler getKogitoWorkItemHandler(String name) {
        return this.workItemHandlers.get(name);
    }

    public void registerWorkItemHandler(String workItemName, KogitoWorkItemHandler handler) {
        this.workItemHandlers.put(workItemName, handler);
    }

    public void transitionWorkItem(String id, WorkItemTransition transition) {
        InternalKogitoWorkItem workItem = this.getWorkItem(id);
        if (workItem == null) {
            throw new WorkItemNotFoundException(id);
        }
        this.transitionWorkItem(workItem, transition, true);
    }

    public void transitionWorkItem(InternalKogitoWorkItem workItem, WorkItemTransition transition, boolean signal) {
        KogitoWorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
        if (handler == null) {
            throw new KogitoWorkItemHandlerNotFoundException(workItem.getName());
        }
        WorkItemTransition lastTransition = null;
        Optional nextTransition = Optional.of(transition);
        while (nextTransition.isPresent()) {
            lastTransition = nextTransition.get();
            nextTransition = handler.transitionToPhase((KogitoWorkItemManager)this, (KogitoWorkItem)workItem, nextTransition.get());
            this.kruntime.getProcessEventSupport().fireBeforeWorkItemTransition(workItem.getProcessInstance(), (KogitoWorkItem)workItem, lastTransition, this.kruntime.getKieRuntime());
            workItem.getProcessInstance().signalEvent("workItemTransition", (Object)transition);
            this.kruntime.getProcessEventSupport().fireAfterWorkItemTransition(workItem.getProcessInstance(), (KogitoWorkItem)workItem, lastTransition, this.kruntime.getKieRuntime());
        }
        if (lastTransition.termination().isPresent()) {
            this.internalRemoveWorkItem(workItem.getStringId());
            if (signal) {
                switch ((WorkItemTerminationType)lastTransition.termination().get()) {
                    case COMPLETE: {
                        workItem.setState(2);
                        workItem.getProcessInstance().signalEvent("workItemCompleted", (Object)workItem);
                        break;
                    }
                    case ABORT: {
                        workItem.setState(3);
                        workItem.getProcessInstance().signalEvent("workItemAborted", (Object)workItem);
                    }
                }
            }
        }
    }

    @Override
    public void internalAddWorkItem(InternalKogitoWorkItem workItem) {
        this.workItems.put(workItem.getStringId(), workItem);
    }

    public void abortWorkItem(String id, Policy ... policies) {
        InternalKogitoWorkItem workItem = this.getWorkItem(id);
        Stream.of(policies).forEach(p -> p.enforce((KogitoWorkItem)workItem));
        this.internalAbortWorkItem(workItem.getStringId());
        workItem.setState(3);
        this.kruntime.signalEvent("workItemAborted", (Object)workItem, workItem.getProcessInstanceId());
    }

    @Override
    public void internalAbortWorkItem(String id) {
        InternalKogitoWorkItem workItem = this.getWorkItem(id);
        KogitoWorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
        if (handler == null) {
            throw new KogitoWorkItemHandlerNotFoundException(workItem.getName());
        }
        WorkItemTransition transition = handler.abortTransition(workItem.getPhaseStatus(), new Policy[0]);
        this.transitionWorkItem(workItem, transition, false);
    }

    public void completeWorkItem(String id, Map<String, Object> results, Policy ... policies) {
        InternalKogitoWorkItem workItem = this.getWorkItem(id);
        Stream.of(policies).forEach(p -> p.enforce((KogitoWorkItem)workItem));
        workItem.setResults(results != null ? results : Collections.emptyMap());
        this.internalCompleteWorkItem(workItem);
        workItem.setState(2);
        this.kruntime.signalEvent("workItemCompleted", (Object)workItem, workItem.getProcessInstanceId());
    }

    @Override
    public void internalCompleteWorkItem(InternalKogitoWorkItem workItem) {
        KogitoWorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
        if (handler == null) {
            throw new KogitoWorkItemHandlerNotFoundException(workItem.getName());
        }
        WorkItemTransition transition = handler.completeTransition(workItem.getPhaseStatus(), workItem.getResults(), new Policy[0]);
        this.transitionWorkItem(workItem, transition, false);
        this.internalRemoveWorkItem(workItem.getStringId());
    }

    @Override
    public void internalExecuteWorkItem(InternalKogitoWorkItem workItem) {
        this.internalAddWorkItem(workItem);
        KogitoWorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
        if (handler == null) {
            throw new KogitoWorkItemHandlerNotFoundException(workItem.getName());
        }
        WorkItemTransition transition = handler.startingTransition(Collections.emptyMap(), new Policy[0]);
        this.transitionWorkItem(workItem, transition, true);
    }

    @Override
    public InternalKogitoWorkItem getWorkItem(String id) {
        return this.workItems.get(id);
    }

    @Override
    public void internalRemoveWorkItem(String id) {
        this.workItems.remove(id);
    }

    @Override
    public void signalEvent(String type, Object event, String processInstanceId) {
        this.kruntime.signalEvent(type, event, processInstanceId);
    }

    @Override
    public void retryWorkItem(String workItemId, Map<String, Object> params) {
        Map<String, Object> normalizedParams = params != null && params.isEmpty() ? Collections.emptyMap() : params;
        this.retryWorkItemWithParams(workItemId, normalizedParams);
    }

    public void retryWorkItemWithParams(String workItemId, Map<String, Object> map) {
        InternalKogitoWorkItem workItem = this.workItems.get(workItemId);
        workItem.setPhaseId(null);
        workItem.setPhaseStatus(null);
        workItem.setParameters(map);
        this.internalExecuteWorkItem(workItem);
    }

    @Override
    public Set<WorkItem> getWorkItems() {
        return this.workItems.values().stream().collect(Collectors.toSet());
    }

    public void completeWorkItem(long id, Map<String, Object> results) {
        throw new UnsupportedOperationException();
    }

    public void abortWorkItem(long id) {
        throw new UnsupportedOperationException();
    }
}

