/**
 *  Copyright 2020 Red Hat, Inc. and/or its affiliates.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.acme.sw.onboarding.services;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.acme.sw.onboarding.model.Assignment;
import org.acme.sw.onboarding.model.Patient;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;

/*
This is a client for our own generated AssignmentUnit endpoint generated by Kogito Rules
This is needed to align the JSON node object with our chain of calls.
After implementing https://github.com/serverlessworkflow/specification/issues/149 this problem
will be handled directly by the workflow implementation, so a output of a function could be transformed
before the input of the next function.
 */

@Path("/assign-doctor")
@Produces(MediaType.APPLICATION_JSON)
@Consumes(MediaType.APPLICATION_JSON)
@RegisterRestClient
public interface AssignmentUnitClient {

    @POST
    @Path("/first")
    Patient assignDoctorFirst(Assignment assignment);
}
