/*
 * Decompiled with CFR 0.152.
 */
package org.acme.sw.onboarding.queries;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.acme.sw.onboarding.model.Doctor;
import org.acme.sw.onboarding.model.Patient;
import org.acme.sw.onboarding.model.SymptomSpecialty;
import org.acme.sw.onboarding.services.DoctorService;
import org.acme.sw.onboarding.services.SymptomSpecialtyService;
import org.kie.kogito.rules.DataSource;
import org.kie.kogito.rules.DataStore;
import org.kie.kogito.rules.RuleUnitData;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AssignmentUnit
implements RuleUnitData {
    private DataStore<Patient> patients = DataSource.createStore();
    private DataStore<Doctor> doctors = DataSource.createStore();
    private DataStore<SymptomSpecialty> symptomSpecialties = DataSource.createStore();

    public AssignmentUnit() {
        this.populate();
    }

    private void populate() {
        DoctorService.get().getDoctors().forEach(arg_0 -> this.doctors.add(arg_0));
        SymptomSpecialtyService.get().getSymptomSpecialties().forEach(arg_0 -> this.symptomSpecialties.add(arg_0));
    }

    public DataStore<Patient> getPatients() {
        return this.patients;
    }

    public void setPatients(DataStore<Patient> patients) {
        this.patients = patients;
    }

    public void addPatients(List<Patient> patientList) {
        for (Patient p : patientList) {
            this.patients.add((Object)p);
        }
    }

    @JsonIgnore
    public DataStore<Doctor> getDoctors() {
        return this.doctors;
    }

    public void setDoctors(DataStore<Doctor> doctors) {
        this.doctors = doctors;
    }

    @JsonIgnore
    public DataStore<SymptomSpecialty> getSymptomSpecialties() {
        return this.symptomSpecialties;
    }

    public void setSymptomSpecialties(DataStore<SymptomSpecialty> symptomSpecialties) {
        this.symptomSpecialties = symptomSpecialties;
    }
}

