/*
 * Decompiled with CFR 0.152.
 */
package org.acme.sw.onboarding.resources;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.acme.sw.onboarding.model.Patient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/onboarding/patient")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class PatientResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PatientResource.class);
    private final List<Patient> patients = new ArrayList<Patient>();

    @POST
    public Response storeNewPatient(@NotNull Patient patient) {
        LOGGER.debug("Received patient to store in the internal in memory database: {}", (Object)patient);
        patient.setId(UUID.randomUUID().toString());
        this.patients.add(patient);
        LOGGER.debug("Patient has been stored in the internal memory: {}", (Object)patient);
        return Response.ok((Object)patient).build();
    }

    @GET
    public List<Patient> getPatients() {
        return this.patients;
    }

    @GET
    @Path(value="/{id}")
    public Optional<Patient> getPatient(@NotEmpty @PathParam(value="id") String patientId) {
        return this.patients.stream().filter(p -> patientId.equals(p.getId())).findFirst();
    }
}

