/*
 * Decompiled with CFR 0.152.
 */
package org.acme.sw.onboarding.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.acme.sw.onboarding.model.Doctor;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Patient {
    private String name;
    private String id;
    private List<String> symptoms = new ArrayList<String>();
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private LocalDate dateOfBirth;
    private Doctor assignedDoctor;

    public Doctor getAssignedDoctor() {
        return this.assignedDoctor;
    }

    public void setAssignedDoctor(Doctor assignedDoctor) {
        this.assignedDoctor = assignedDoctor;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getSymptoms() {
        return this.symptoms;
    }

    public void setSymptoms(List<String> symptoms) {
        this.symptoms = symptoms;
    }

    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Patient patient = (Patient)o;
        return Objects.equals(this.name, patient.name) && Objects.equals(this.id, patient.id) && Objects.equals(this.dateOfBirth, patient.dateOfBirth);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.id, this.dateOfBirth);
    }

    public String toString() {
        return "Patient{name='" + this.name + "', id='" + this.id + "', symptoms=" + this.symptoms + ", dateOfBirth=" + this.dateOfBirth + "}";
    }
}

