/*
 * Decompiled with CFR 0.152.
 */
package org.acme.numbers;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.acme.numbers.Numbers;

@Path(value="/numbers")
@Produces(value={"application/json"})
@ApplicationScoped
public class NumbersResource {
    private ObjectMapper objectMapper;
    private Random rand;

    @PostConstruct
    void init() {
        this.objectMapper = new ObjectMapper();
        this.rand = new Random();
    }

    @GET
    @Path(value="random")
    public Response getRandom(@QueryParam(value="bound") @DefaultValue(value="10") int bound) {
        return this.fromNumber("randomNumber", this.rand.nextInt(bound));
    }

    @POST
    @Path(value="{number}/multiplyByAndSum")
    public Response multiplyByAndSum(@PathParam(value="number") int multiplier, Numbers numbers) {
        return this.fromNumber("sum", numbers.getNumbers().stream().map(n -> n.intValue() * multiplier).collect(Collectors.summingInt(Integer::intValue)));
    }

    private Response fromNumber(String name, int number) {
        return Response.ok().entity((Object)this.objectMapper.createObjectNode().put(name, number)).build();
    }
}

