package org.kie.kogito.serverless;

import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.ruleflow.core.RuleFlowProcessFactory;
import org.drools.core.util.KieFunctions;

@org.springframework.stereotype.Component("jsonservicecall")
public class JsonservicecallProcess extends org.kie.kogito.process.impl.AbstractProcess<org.kie.kogito.serverless.JsonservicecallModel> {

    public JsonservicecallProcess(org.kie.kogito.app.Application app) {
        this(app, new org.kie.kogito.handlers.ClassifierService_classifySmallMedium_11_Handler(), new org.kie.kogito.handlers.ClassifierService_classifyLarge_15_Handler(), new org.kie.kogito.handlers.CountriesService_getCountryInfo_6_Handler());
    }

    @org.springframework.beans.factory.annotation.Autowired()
    public JsonservicecallProcess(org.kie.kogito.app.Application app, org.kie.kogito.handlers.ClassifierService_classifySmallMedium_11_Handler classifierService_classifySmallMedium_11_Handler, org.kie.kogito.handlers.ClassifierService_classifyLarge_15_Handler classifierService_classifyLarge_15_Handler, org.kie.kogito.handlers.CountriesService_getCountryInfo_6_Handler countriesService_getCountryInfo_6_Handler) {
        super(app, java.util.Arrays.asList(classifierService_classifySmallMedium_11_Handler, classifierService_classifyLarge_15_Handler, countriesService_getCountryInfo_6_Handler));
        activate();
    }

    public JsonservicecallProcess() {
    }

    @Override()
    public org.kie.kogito.serverless.JsonservicecallProcessInstance createInstance(org.kie.kogito.serverless.JsonservicecallModel value) {
        return new org.kie.kogito.serverless.JsonservicecallProcessInstance(this, value, this.createProcessRuntime());
    }

    public org.kie.kogito.serverless.JsonservicecallProcessInstance createInstance(java.lang.String businessKey, org.kie.kogito.serverless.JsonservicecallModel value) {
        return new org.kie.kogito.serverless.JsonservicecallProcessInstance(this, value, businessKey, this.createProcessRuntime());
    }

    @Override()
    public org.kie.kogito.serverless.JsonservicecallModel createModel() {
        return new org.kie.kogito.serverless.JsonservicecallModel();
    }

    public org.kie.kogito.serverless.JsonservicecallProcessInstance createInstance(org.kie.kogito.Model value) {
        return this.createInstance((org.kie.kogito.serverless.JsonservicecallModel) value);
    }

    public org.kie.kogito.serverless.JsonservicecallProcessInstance createInstance(java.lang.String businessKey, org.kie.kogito.Model value) {
        return this.createInstance(businessKey, (org.kie.kogito.serverless.JsonservicecallModel) value);
    }

    public org.kie.kogito.serverless.JsonservicecallProcessInstance createInstance(org.kie.api.runtime.process.WorkflowProcessInstance wpi) {
        return new org.kie.kogito.serverless.JsonservicecallProcessInstance(this, this.createModel(), this.createProcessRuntime(), wpi);
    }

    public org.kie.kogito.serverless.JsonservicecallProcessInstance createReadOnlyInstance(org.kie.api.runtime.process.WorkflowProcessInstance wpi) {
        return new org.kie.kogito.serverless.JsonservicecallProcessInstance(this, this.createModel(), wpi);
    }

    public org.kie.api.definition.process.Process process() {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess("jsonservicecall");
        factory.variable("workflowdata", new ObjectDataType("com.fasterxml.jackson.databind.JsonNode"), "customTags", null);
        factory.name("Service Call Workflow");
        factory.packageName("org.kie.kogito.serverless");
        factory.dynamic(false);
        factory.version("1.0");
        factory.visibility("Public");
        org.jbpm.ruleflow.core.factory.StartNodeFactory startNode1 = factory.startNode(1);
        startNode1.name("Start");
        startNode1.interrupting(false);
        startNode1.metaData("UniqueId", "_jbpm-unique-22");
        startNode1.done();
        org.jbpm.ruleflow.core.factory.EndNodeFactory endNode2 = factory.endNode(2);
        endNode2.name("End");
        endNode2.terminate(true);
        endNode2.metaData("UniqueId", "_jbpm-unique-23");
        endNode2.done();
        org.jbpm.ruleflow.core.factory.EndNodeFactory endNode3 = factory.endNode(3);
        endNode3.name("End");
        endNode3.terminate(true);
        endNode3.metaData("UniqueId", "_jbpm-unique-24");
        endNode3.done();
        org.jbpm.ruleflow.core.factory.CompositeContextNodeFactory compositeContextNode4 = factory.compositeContextNode(4);
        compositeContextNode4.name("GetCountryInfo");
        compositeContextNode4.metaData("UniqueId", "_jbpm-unique-25");
        compositeContextNode4.autoComplete(true);
        org.jbpm.ruleflow.core.factory.StartNodeFactory startNode5 = compositeContextNode4.startNode(5);
        startNode5.name("EmbeddedStart");
        startNode5.interrupting(false);
        startNode5.metaData("UniqueId", "_jbpm-unique-26");
        startNode5.done();
        org.jbpm.ruleflow.core.factory.WorkItemNodeFactory workItemNode6 = compositeContextNode4.workItemNode(6);
        workItemNode6.name("countryInfoFunction");
        workItemNode6.workName("org.kie.kogito.serverless.examples.CountriesService_getCountryInfo_6_Handler");
        workItemNode6.workParameter("Interface", "org.kie.kogito.serverless.examples.CountriesService");
        workItemNode6.workParameter("Operation", "getCountryInfo");
        workItemNode6.workParameter("interfaceImplementationRef", "org.kie.kogito.serverless.examples.CountriesService");
        workItemNode6.workParameter("operationImplementationRef", "getCountryInfo");
        workItemNode6.workParameter("ParameterType", "com.fasterxml.jackson.databind.JsonNode");
        workItemNode6.workParameter("implementation", "Java");
        workItemNode6.inMapping("Parameter", "workflowdata");
        workItemNode6.outMapping("Result", "workflowdata");
        workItemNode6.done();
        workItemNode6.metaData("UniqueId", "_jbpm-unique-27");
        workItemNode6.metaData("Type", "Service Task");
        org.jbpm.ruleflow.core.factory.EndNodeFactory endNode7 = compositeContextNode4.endNode(7);
        endNode7.name("EmbeddedEnd");
        endNode7.terminate(true);
        endNode7.metaData("UniqueId", "_jbpm-unique-28");
        endNode7.done();
        compositeContextNode4.connection(5, 6, "5_6");
        compositeContextNode4.connection(6, 7, "6_7");
        compositeContextNode4.done();
        org.jbpm.ruleflow.core.factory.SplitFactory splitNode8 = factory.splitNode(8);
        splitNode8.name("ClassifyByPopulation");
        splitNode8.type(2);
        splitNode8.metaData("UniqueId", "8");
        splitNode8.metaData("Default", "8_9");
        splitNode8.constraint(13, "8_13", "DROOLS_DEFAULT", "java", kcontext -> {
            com.fasterxml.jackson.databind.JsonNode workflowdata = (com.fasterxml.jackson.databind.JsonNode) kcontext.getVariable("workflowdata");
            return java.lang.Integer.parseInt(workflowdata.get("population").textValue()) >= 20000000;
        }, 0);
        splitNode8.constraint(9, "8_9", "DROOLS_DEFAULT", "java", kcontext -> {
            com.fasterxml.jackson.databind.JsonNode workflowdata = (com.fasterxml.jackson.databind.JsonNode) kcontext.getVariable("workflowdata");
            return java.lang.Integer.parseInt(workflowdata.get("population").textValue()) < 20000000;
        }, 0);
        splitNode8.done();
        org.jbpm.ruleflow.core.factory.CompositeContextNodeFactory compositeContextNode9 = factory.compositeContextNode(9);
        compositeContextNode9.name("ClassifyAsSmallOrMedium");
        compositeContextNode9.metaData("UniqueId", "_jbpm-unique-30");
        compositeContextNode9.autoComplete(true);
        org.jbpm.ruleflow.core.factory.StartNodeFactory startNode10 = compositeContextNode9.startNode(10);
        startNode10.name("EmbeddedStart");
        startNode10.interrupting(false);
        startNode10.metaData("UniqueId", "_jbpm-unique-31");
        startNode10.done();
        org.jbpm.ruleflow.core.factory.WorkItemNodeFactory workItemNode11 = compositeContextNode9.workItemNode(11);
        workItemNode11.name("classifySmallMediumFunction");
        workItemNode11.workName("org.kie.kogito.serverless.examples.ClassifierService_classifySmallMedium_11_Handler");
        workItemNode11.workParameter("Interface", "org.kie.kogito.serverless.examples.ClassifierService");
        workItemNode11.workParameter("Operation", "classifySmallMedium");
        workItemNode11.workParameter("interfaceImplementationRef", "org.kie.kogito.serverless.examples.ClassifierService");
        workItemNode11.workParameter("operationImplementationRef", "classifySmallMedium");
        workItemNode11.workParameter("ParameterType", "com.fasterxml.jackson.databind.JsonNode");
        workItemNode11.workParameter("implementation", "Java");
        workItemNode11.inMapping("Parameter", "workflowdata");
        workItemNode11.outMapping("Result", "workflowdata");
        workItemNode11.done();
        workItemNode11.metaData("UniqueId", "_jbpm-unique-32");
        workItemNode11.metaData("Type", "Service Task");
        org.jbpm.ruleflow.core.factory.EndNodeFactory endNode12 = compositeContextNode9.endNode(12);
        endNode12.name("EmbeddedEnd");
        endNode12.terminate(true);
        endNode12.metaData("UniqueId", "_jbpm-unique-33");
        endNode12.done();
        compositeContextNode9.connection(10, 11, "10_11");
        compositeContextNode9.connection(11, 12, "11_12");
        compositeContextNode9.done();
        org.jbpm.ruleflow.core.factory.CompositeContextNodeFactory compositeContextNode13 = factory.compositeContextNode(13);
        compositeContextNode13.name("ClassifyAsLarge");
        compositeContextNode13.metaData("UniqueId", "_jbpm-unique-34");
        compositeContextNode13.autoComplete(true);
        org.jbpm.ruleflow.core.factory.EndNodeFactory endNode16 = compositeContextNode13.endNode(16);
        endNode16.name("EmbeddedEnd");
        endNode16.terminate(true);
        endNode16.metaData("UniqueId", "_jbpm-unique-37");
        endNode16.done();
        org.jbpm.ruleflow.core.factory.StartNodeFactory startNode14 = compositeContextNode13.startNode(14);
        startNode14.name("EmbeddedStart");
        startNode14.interrupting(false);
        startNode14.metaData("UniqueId", "_jbpm-unique-35");
        startNode14.done();
        org.jbpm.ruleflow.core.factory.WorkItemNodeFactory workItemNode15 = compositeContextNode13.workItemNode(15);
        workItemNode15.name("classifyLargeFunction");
        workItemNode15.workName("org.kie.kogito.serverless.examples.ClassifierService_classifyLarge_15_Handler");
        workItemNode15.workParameter("Interface", "org.kie.kogito.serverless.examples.ClassifierService");
        workItemNode15.workParameter("Operation", "classifyLarge");
        workItemNode15.workParameter("interfaceImplementationRef", "org.kie.kogito.serverless.examples.ClassifierService");
        workItemNode15.workParameter("operationImplementationRef", "classifyLarge");
        workItemNode15.workParameter("ParameterType", "com.fasterxml.jackson.databind.JsonNode");
        workItemNode15.workParameter("implementation", "Java");
        workItemNode15.inMapping("Parameter", "workflowdata");
        workItemNode15.outMapping("Result", "workflowdata");
        workItemNode15.done();
        workItemNode15.metaData("UniqueId", "_jbpm-unique-36");
        workItemNode15.metaData("Type", "Service Task");
        compositeContextNode13.connection(15, 16, "15_16");
        compositeContextNode13.connection(14, 15, "14_15");
        compositeContextNode13.done();
        factory.connection(9, 2, "9_2");
        factory.connection(13, 3, "13_3");
        factory.connection(1, 4, "1_4");
        factory.connection(4, 8, "4_8");
        factory.connection(8, 9, "8_9");
        factory.connection(8, 13, "8_13");
        factory.validate();
        return factory.getProcess();
    }
}
