/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.examples;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.jboss.logging.Logger;
import org.kie.kogito.serverless.examples.Country;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class CountriesService {
    private static final Logger LOG = Logger.getLogger(CountriesService.class);
    @Autowired
    private RestTemplate restTemplate;

    public JsonNode getCountryInfo(JsonNode nameNode) {
        JsonNode retNode = null;
        try {
            ResponseEntity response = this.restTemplate.getForEntity("https://restcountries.eu/rest/v2/name/{name}", Country[].class, new Object[]{nameNode.get("name").asText()});
            Country[] countries = (Country[])response.getBody();
            Country country = countries[0];
            ObjectMapper mapper = new ObjectMapper();
            retNode = (JsonNode)mapper.convertValue((Object)country, JsonNode.class);
            String population = retNode.get("population").asText();
            ((ObjectNode)retNode).put("population", Integer.parseInt(population));
        }
        catch (RestClientException e) {
            LOG.error((Object)e.getMessage());
        }
        return retNode;
    }
}

