/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.kie.kogito.taskassigning.core.model.ChainElement;
import org.kie.kogito.taskassigning.core.model.ModelConstants;
import org.kie.kogito.taskassigning.core.model.TaskAssigningSolution;
import org.kie.kogito.taskassigning.core.model.TaskAssignment;
import org.kie.kogito.taskassigning.core.model.User;
import org.kie.kogito.taskassigning.core.model.solver.TaskHelper;
import org.kie.kogito.taskassigning.service.PlanningItem;
import org.kie.kogito.taskassigning.service.TaskAssigningServiceContext;

public class PlanningBuilder {
    private TaskAssigningSolution solution;
    private int publishWindowSize;
    private TaskAssigningServiceContext context;

    private PlanningBuilder() {
    }

    public static PlanningBuilder create() {
        return new PlanningBuilder();
    }

    public PlanningBuilder forSolution(TaskAssigningSolution solution) {
        this.solution = solution;
        return this;
    }

    public PlanningBuilder withContext(TaskAssigningServiceContext context) {
        this.context = context;
        return this;
    }

    public PlanningBuilder withPublishWindowSize(int publishWindowSize) {
        this.publishWindowSize = publishWindowSize;
        return this;
    }

    public List<PlanningItem> build() {
        return this.solution.getUserList().stream().map(this::buildPlanningItems).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<PlanningItem> buildPlanningItems(User user) {
        List taskAssignments = TaskHelper.extractTaskAssignments((ChainElement)user, (Predicate)ModelConstants.IS_NOT_DUMMY_TASK_ASSIGNMENT);
        Iterator taskAssignmentsIt = taskAssignments.iterator();
        ArrayList<PlanningItem> result = new ArrayList<PlanningItem>();
        for (int count = 0; taskAssignmentsIt.hasNext() && (count < this.publishWindowSize || ModelConstants.IS_PLANNING_USER.test(user.getId())); ++count) {
            TaskAssignment taskAssignment = (TaskAssignment)taskAssignmentsIt.next();
            if (this.context.isTaskPublished(taskAssignment.getId())) continue;
            result.add(new PlanningItem(taskAssignment.getTask(), user.getId()));
        }
        return result;
    }
}

