/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service;

import java.time.ZonedDateTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.kie.kogito.taskassigning.service.ServiceMessage;
import org.kie.kogito.taskassigning.service.ServiceStatus;
import org.kie.kogito.taskassigning.service.ServiceStatusInfo;

public class TaskAssigningServiceContext {
    private final AtomicLong changeSetIds = new AtomicLong();
    private final AtomicLong currentChangeSetId = new AtomicLong();
    private final AtomicLong lastProcessedChangeSetId = new AtomicLong(-1L);
    private final Map<String, TaskContext> taskContextMap = new ConcurrentHashMap<String, TaskContext>();
    private final AtomicReference<ServiceStatusInfo> statusInfo = new AtomicReference<ServiceStatusInfo>(new ServiceStatusInfo(ServiceStatus.STARTING));

    public long getCurrentChangeSetId() {
        return this.currentChangeSetId.get();
    }

    public void setCurrentChangeSetId(long currentChangeSetId) {
        this.currentChangeSetId.set(currentChangeSetId);
    }

    public long nextChangeSetId() {
        return this.changeSetIds.incrementAndGet();
    }

    public boolean isProcessedChangeSet(long changeSetId) {
        return changeSetId <= this.lastProcessedChangeSetId.get();
    }

    public boolean isCurrentChangeSetProcessed() {
        return this.isProcessedChangeSet(this.currentChangeSetId.get());
    }

    public void setProcessedChangeSet(long changeSetId) {
        this.lastProcessedChangeSetId.set(changeSetId);
    }

    public void setTaskPublished(String taskId, boolean published) {
        TaskContext taskContext = this.taskContextMap.computeIfAbsent(taskId, id -> new TaskContext());
        taskContext.setPublished(published);
    }

    public boolean isTaskPublished(String taskId) {
        TaskContext taskContext = this.taskContextMap.get(taskId);
        return taskContext != null && taskContext.isPublished();
    }

    public void setTaskLastEventTime(String taskId, ZonedDateTime lastEventTime) {
        TaskContext taskContext = this.taskContextMap.computeIfAbsent(taskId, id -> new TaskContext());
        taskContext.setLastEventTime(lastEventTime);
    }

    public ZonedDateTime getTaskLastEventTime(String taskId) {
        TaskContext taskContext = this.taskContextMap.get(taskId);
        return taskContext != null ? taskContext.getLastEventTime() : null;
    }

    public boolean isNewTaskEventTime(String taskId, ZonedDateTime taskEventTime) {
        ZonedDateTime lastTaskEventTime = this.getTaskLastEventTime(taskId);
        return lastTaskEventTime == null || taskEventTime.isAfter(lastTaskEventTime);
    }

    public ServiceStatus getStatus() {
        return this.statusInfo.get().getStatus();
    }

    public void setStatus(ServiceStatus status) {
        this.statusInfo.set(new ServiceStatusInfo(status));
    }

    public void setStatus(ServiceStatus status, ServiceMessage statusMessage) {
        this.statusInfo.set(new ServiceStatusInfo(status, statusMessage));
    }

    public ServiceStatusInfo getStatusInfo() {
        return this.statusInfo.get();
    }

    private static class TaskContext {
        private boolean published;
        private ZonedDateTime lastEventTime;

        private TaskContext() {
        }

        public synchronized void setPublished(boolean published) {
            this.published = published;
        }

        public synchronized boolean isPublished() {
            return this.published;
        }

        public synchronized ZonedDateTime getLastEventTime() {
            return this.lastEventTime;
        }

        public synchronized void setLastEventTime(ZonedDateTime lastEventTime) {
            this.lastEventTime = lastEventTime;
        }
    }
}

