/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service;

import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.kogito.taskassigning.ClientServices;
import org.kie.kogito.taskassigning.index.service.client.DataIndexServiceClient;
import org.kie.kogito.taskassigning.index.service.client.graphql.UserTaskInstance;
import org.kie.kogito.taskassigning.service.config.TaskAssigningConfig;
import org.kie.kogito.taskassigning.service.config.TaskAssigningConfigUtil;

@ApplicationScoped
public class TaskServiceConnector {
    private TaskAssigningConfig config;
    private ClientServices clientServices;
    private DataIndexServiceClient indexServiceClient;

    public TaskServiceConnector() {
    }

    @Inject
    public TaskServiceConnector(TaskAssigningConfig config, ClientServices clientServices) {
        this.config = config;
        this.clientServices = clientServices;
    }

    public List<UserTaskInstance> findAllTasks(List<String> state, int pageSize) {
        ArrayList<UserTaskInstance> result = new ArrayList<UserTaskInstance>();
        HashSet<String> stateSet = new HashSet<String>(state);
        int offset = 0;
        boolean finished = false;
        ZonedDateTime startedAfter = null;
        this.indexServiceClient = this.ensureServiceClient();
        while (!finished) {
            int lastIndex;
            List partialResult = this.indexServiceClient.findTasks(null, startedAfter, UserTaskInstance.Field.STARTED.name(), true, offset, pageSize);
            result.addAll(this.filterByState(stateSet, partialResult));
            if (partialResult.isEmpty() || partialResult.size() < pageSize) {
                finished = true;
                continue;
            }
            offset = 0;
            startedAfter = ((UserTaskInstance)partialResult.get(lastIndex)).getStarted();
            for (lastIndex = partialResult.size() - 1; lastIndex >= 0 && startedAfter.equals(((UserTaskInstance)partialResult.get(lastIndex)).getStarted()); --lastIndex) {
                ++offset;
            }
            startedAfter = startedAfter.minus(1L, ChronoUnit.MILLIS);
        }
        return result;
    }

    private List<UserTaskInstance> filterByState(Set<String> stateSet, List<UserTaskInstance> userTaskList) {
        if (stateSet.isEmpty()) {
            return userTaskList;
        }
        return userTaskList.stream().filter(userTaskInstance -> stateSet.contains(userTaskInstance.getState())).collect(Collectors.toList());
    }

    private DataIndexServiceClient ensureServiceClient() {
        if (this.indexServiceClient == null) {
            this.indexServiceClient = TaskAssigningConfigUtil.createDataIndexServiceClient(this.clientServices, this.config);
        }
        return this.indexServiceClient;
    }
}

