/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service.messaging;

import com.google.common.net.UrlEscapers;
import java.io.IOException;
import java.net.URI;
import java.time.temporal.ChronoUnit;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.kie.kogito.taskassigning.service.messaging.UserTaskEvent;
import org.kie.kogito.taskassigning.service.messaging.UserTaskEventMessage;
import org.kie.kogito.taskassigning.util.JsonUtils;

public class UserTaskEventDeserializer
implements Deserializer<UserTaskEvent> {
    public UserTaskEvent deserialize(String topic, byte[] data) {
        try {
            if (data == null) {
                return null;
            }
            UserTaskEventMessage message = (UserTaskEventMessage)JsonUtils.OBJECT_MAPPER.readValue(data, UserTaskEventMessage.class);
            UserTaskEvent event = message.getData();
            event.setEventTime(message.getTime());
            event.setLastUpdate(message.getTime().truncatedTo(ChronoUnit.MILLIS));
            event.setEndpoint(UserTaskEventDeserializer.buildEndpoint(message.getSource(), event.getProcessInstanceId(), event.getName(), event.getTaskId()));
            return event;
        }
        catch (IOException e) {
            throw new SerializationException("An error was produced during UserTaskEventMessage deserialization: " + e.getMessage(), (Throwable)e);
        }
    }

    private static String buildEndpoint(URI source, String processId, String taskName, String taskId) {
        String escapedTaskName = UrlEscapers.urlPathSegmentEscaper().escape(taskName);
        return source.toString() + String.format("/%s/%s/%s", processId, escapedTaskName, taskId);
    }
}

