/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.kie.kogito.taskassigning.service.TaskAssigningServiceContext;
import org.kie.kogito.taskassigning.service.TaskData;
import org.kie.kogito.taskassigning.service.event.DataEvent;
import org.kie.kogito.taskassigning.service.event.SolutionUpdatedOnBackgroundDataEvent;
import org.kie.kogito.taskassigning.service.event.TaskDataEvent;
import org.kie.kogito.taskassigning.service.event.UserDataEvent;

public class EventUtil {
    private EventUtil() {
    }

    public static List<TaskDataEvent> filterNewestTaskEventsInContext(TaskAssigningServiceContext context, List<DataEvent<?>> dataEvents) {
        ArrayList<TaskDataEvent> result = new ArrayList<TaskDataEvent>();
        List<TaskDataEvent> newestTaskEvents = EventUtil.filterNewestTaskEvents(dataEvents);
        for (TaskDataEvent taskEvent : newestTaskEvents) {
            if (!context.isNewTaskEventTime(taskEvent.getTaskId(), taskEvent.getEventTime())) continue;
            context.setTaskLastEventTime(taskEvent.getTaskId(), taskEvent.getEventTime());
            result.add(taskEvent);
        }
        return result;
    }

    public static <T extends DataEvent<?>> List<TaskDataEvent> filterNewestTaskEvents(List<T> dataEvents) {
        HashMap lastEventPerTask = new HashMap();
        AtomicReference previousEventForTask = new AtomicReference();
        dataEvents.stream().filter(dataEvent -> dataEvent.getDataEventType() == DataEvent.DataEventType.TASK_DATA_EVENT).map(TaskDataEvent.class::cast).forEach(taskDataEvent -> {
            previousEventForTask.set((TaskDataEvent)lastEventPerTask.get(taskDataEvent.getTaskId()));
            if (previousEventForTask.get() == null || taskDataEvent.getEventTime().isAfter(((TaskDataEvent)previousEventForTask.get()).getEventTime())) {
                lastEventPerTask.put(((TaskData)taskDataEvent.getData()).getId(), taskDataEvent);
            }
        });
        return new ArrayList<TaskDataEvent>(lastEventPerTask.values());
    }

    public static UserDataEvent filterNewestUserEvent(List<DataEvent<?>> dataEvents) {
        return dataEvents.stream().filter(event -> event.getDataEventType() == DataEvent.DataEventType.USER_DATA_EVENT).map(UserDataEvent.class::cast).max(Comparator.comparing(DataEvent::getEventTime)).orElse(null);
    }

    public static SolutionUpdatedOnBackgroundDataEvent filterNewestSolutionUpdatedOnBackgroundEvent(List<DataEvent<?>> dataEvents) {
        return dataEvents.stream().filter(event -> event.getDataEventType() == DataEvent.DataEventType.SOLUTION_UPDATED_ON_BACKGROUND_DATA_EVENT).map(SolutionUpdatedOnBackgroundDataEvent.class::cast).max(Comparator.comparing(DataEvent::getEventTime)).orElse(null);
    }
}

