/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kie.kogito.taskassigning.core.model.Task;
import org.kie.kogito.taskassigning.index.service.client.graphql.UserTaskInstance;
import org.kie.kogito.taskassigning.service.TaskData;
import org.kie.kogito.taskassigning.service.event.DataEvent;
import org.kie.kogito.taskassigning.service.event.TaskDataEvent;
import org.kie.kogito.taskassigning.service.messaging.UserTaskEvent;
import org.kie.kogito.taskassigning.util.JsonUtils;

public class TaskUtil {
    private TaskUtil() {
    }

    public static List<TaskData> fromUserTaskInstances(List<UserTaskInstance> userTaskInstances) {
        return TaskUtil.fromMappedType(userTaskInstances, x$0 -> new UserTaskInstanceTaskData((UserTaskInstance)x$0));
    }

    public static List<TaskData> fromTaskDataEvents(List<TaskDataEvent> taskDataEvents) {
        return taskDataEvents.stream().map(DataEvent::getData).collect(Collectors.toList());
    }

    public static TaskData fromUserTaskEvent(UserTaskEvent userTaskEvent) {
        return new UserTaskEventTaskData(userTaskEvent);
    }

    private static <T> List<TaskData> fromMappedType(List<T> values, Function<T, TaskData> mapper) {
        return Optional.ofNullable(values).orElse(Collections.emptyList()).stream().map(mapper).collect(Collectors.toList());
    }

    public static Task fromTaskData(TaskData taskData) {
        return Task.newBuilder().id(taskData.getId()).name(taskData.getName()).state(taskData.getState()).description(taskData.getDescription()).referenceName(taskData.getReferenceName()).priority(taskData.getPriority()).processInstanceId(taskData.getProcessInstanceId()).processId(taskData.getProcessId()).rootProcessInstanceId(taskData.getRootProcessInstanceId()).rootProcessId(taskData.getRootProcessId()).potentialUsers(taskData.getPotentialUsers()).potentialGroups(taskData.getPotentialGroups()).adminUsers(taskData.getAdminUsers()).adminGroups(taskData.getAdminGroups()).excludedUsers(taskData.getExcludedUsers()).started(taskData.getStarted()).completed(taskData.getCompleted()).lastUpdate(taskData.getLastUpdate()).inputData(TaskUtil.fromJsonNode(taskData.getInputs())).endpoint(taskData.getEndpoint()).build();
    }

    private static Map<String, Object> fromJsonNode(JsonNode node) {
        return (Map)JsonUtils.OBJECT_MAPPER.convertValue((Object)node, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    private static String sanitizeStringValue(String priority) {
        if (priority != null && priority.isEmpty()) {
            return null;
        }
        return priority;
    }

    private static <T> Set<T> toSet(Collection<T> collection) {
        return collection != null ? new HashSet<T>(collection) : new HashSet();
    }

    private static class UserTaskInstanceTaskData
    implements TaskData {
        private UserTaskInstance userTaskInstance;

        private UserTaskInstanceTaskData(UserTaskInstance userTaskInstance) {
            this.userTaskInstance = userTaskInstance;
        }

        @Override
        public String getId() {
            return this.userTaskInstance.getId();
        }

        @Override
        public String getName() {
            return this.userTaskInstance.getName();
        }

        @Override
        public String getState() {
            return this.userTaskInstance.getState();
        }

        @Override
        public String getDescription() {
            return TaskUtil.sanitizeStringValue(this.userTaskInstance.getDescription());
        }

        @Override
        public String getReferenceName() {
            return this.userTaskInstance.getReferenceName();
        }

        @Override
        public String getPriority() {
            return TaskUtil.sanitizeStringValue(this.userTaskInstance.getPriority());
        }

        @Override
        public String getProcessInstanceId() {
            return this.userTaskInstance.getProcessInstanceId();
        }

        @Override
        public String getProcessId() {
            return this.userTaskInstance.getProcessId();
        }

        @Override
        public String getRootProcessInstanceId() {
            return this.userTaskInstance.getRootProcessInstanceId();
        }

        @Override
        public String getRootProcessId() {
            return this.userTaskInstance.getRootProcessId();
        }

        @Override
        public String getActualOwner() {
            return this.userTaskInstance.getActualOwner();
        }

        @Override
        public Set<String> getPotentialUsers() {
            return TaskUtil.toSet(this.userTaskInstance.getPotentialUsers());
        }

        @Override
        public Set<String> getPotentialGroups() {
            return TaskUtil.toSet(this.userTaskInstance.getPotentialGroups());
        }

        @Override
        public Set<String> getAdminUsers() {
            return TaskUtil.toSet(this.userTaskInstance.getAdminUsers());
        }

        @Override
        public Set<String> getAdminGroups() {
            return TaskUtil.toSet(this.userTaskInstance.getAdminGroups());
        }

        @Override
        public Set<String> getExcludedUsers() {
            return TaskUtil.toSet(this.userTaskInstance.getExcludedUsers());
        }

        @Override
        public ZonedDateTime getStarted() {
            return this.userTaskInstance.getStarted();
        }

        @Override
        public ZonedDateTime getCompleted() {
            return this.userTaskInstance.getCompleted();
        }

        @Override
        public ZonedDateTime getLastUpdate() {
            return this.userTaskInstance.getLastUpdate();
        }

        @Override
        public JsonNode getInputs() {
            return this.userTaskInstance.getInputs();
        }

        @Override
        public String getEndpoint() {
            return this.userTaskInstance.getEndpoint();
        }
    }

    private static class UserTaskEventTaskData
    implements TaskData {
        private UserTaskEvent userTaskEvent;

        private UserTaskEventTaskData(UserTaskEvent userTaskEvent) {
            this.userTaskEvent = userTaskEvent;
        }

        @Override
        public String getId() {
            return this.userTaskEvent.getTaskId();
        }

        @Override
        public String getName() {
            return this.userTaskEvent.getName();
        }

        @Override
        public String getState() {
            return this.userTaskEvent.getState();
        }

        @Override
        public String getDescription() {
            return TaskUtil.sanitizeStringValue(this.userTaskEvent.getDescription());
        }

        @Override
        public String getReferenceName() {
            return this.userTaskEvent.getReferenceName();
        }

        @Override
        public String getPriority() {
            return TaskUtil.sanitizeStringValue(this.userTaskEvent.getPriority());
        }

        @Override
        public String getProcessInstanceId() {
            return this.userTaskEvent.getProcessInstanceId();
        }

        @Override
        public String getProcessId() {
            return this.userTaskEvent.getProcessId();
        }

        @Override
        public String getRootProcessInstanceId() {
            return this.userTaskEvent.getRootProcessInstanceId();
        }

        @Override
        public String getRootProcessId() {
            return this.userTaskEvent.getRootProcessId();
        }

        @Override
        public String getActualOwner() {
            return this.userTaskEvent.getActualOwner();
        }

        @Override
        public Set<String> getPotentialUsers() {
            return TaskUtil.toSet(this.userTaskEvent.getPotentialUsers());
        }

        @Override
        public Set<String> getPotentialGroups() {
            return TaskUtil.toSet(this.userTaskEvent.getPotentialGroups());
        }

        @Override
        public Set<String> getAdminUsers() {
            return TaskUtil.toSet(this.userTaskEvent.getAdminUsers());
        }

        @Override
        public Set<String> getAdminGroups() {
            return TaskUtil.toSet(this.userTaskEvent.getAdminGroups());
        }

        @Override
        public Set<String> getExcludedUsers() {
            return TaskUtil.toSet(this.userTaskEvent.getExcludedUsers());
        }

        @Override
        public ZonedDateTime getStarted() {
            return this.userTaskEvent.getStarted();
        }

        @Override
        public ZonedDateTime getCompleted() {
            return this.userTaskEvent.getCompleted();
        }

        @Override
        public ZonedDateTime getLastUpdate() {
            return this.userTaskEvent.getLastUpdate();
        }

        @Override
        public JsonNode getInputs() {
            return this.userTaskEvent.getInputs();
        }

        @Override
        public String getEndpoint() {
            return this.userTaskEvent.getEndpoint();
        }
    }
}

