/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;

public abstract class RunnableBase
implements Runnable {
    protected final AtomicReference<Status> status = new AtomicReference<Status>(Status.STOPPED);
    protected final Semaphore startPermit = new Semaphore(0);

    protected void startCheck() {
        if (!this.status.compareAndSet(Status.STOPPED, Status.STARTING)) {
            throw new IllegalStateException("start method can only be invoked when the status is STOPPED");
        }
    }

    public void destroy() {
        this.status.set(Status.DESTROYED);
        this.startPermit.release();
    }

    public boolean isDestroyed() {
        return this.status.get() == Status.DESTROYED;
    }

    protected boolean isAlive() {
        return this.status.get() != Status.DESTROYED && !Thread.currentThread().isInterrupted();
    }

    protected static enum Status {
        STARTING,
        STARTED,
        STOPPING,
        STOPPED,
        DESTROYED;

    }
}

