/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kie.kogito.taskassigning.core.model.ChainElement;
import org.kie.kogito.taskassigning.core.model.IdentifiableElement;
import org.kie.kogito.taskassigning.core.model.ModelConstants;
import org.kie.kogito.taskassigning.core.model.Task;
import org.kie.kogito.taskassigning.core.model.TaskAssigningSolution;
import org.kie.kogito.taskassigning.core.model.TaskAssignment;
import org.kie.kogito.taskassigning.core.model.User;
import org.kie.kogito.taskassigning.core.model.solver.TaskHelper;
import org.kie.kogito.taskassigning.core.model.solver.realtime.AddTaskProblemFactChange;
import org.kie.kogito.taskassigning.core.model.solver.realtime.AddUserProblemFactChange;
import org.kie.kogito.taskassigning.core.model.solver.realtime.AssignTaskProblemFactChange;
import org.kie.kogito.taskassigning.core.model.solver.realtime.DisableUserProblemFactChange;
import org.kie.kogito.taskassigning.core.model.solver.realtime.ReleaseTaskProblemFactChange;
import org.kie.kogito.taskassigning.core.model.solver.realtime.RemoveTaskProblemFactChange;
import org.kie.kogito.taskassigning.core.model.solver.realtime.RemoveUserProblemFactChange;
import org.kie.kogito.taskassigning.core.model.solver.realtime.TaskInfoChangeProblemFactChange;
import org.kie.kogito.taskassigning.core.model.solver.realtime.UserPropertyChangeProblemFactChange;
import org.kie.kogito.taskassigning.service.TaskAssigningException;
import org.kie.kogito.taskassigning.service.TaskAssigningServiceContext;
import org.kie.kogito.taskassigning.service.TaskData;
import org.kie.kogito.taskassigning.service.TaskState;
import org.kie.kogito.taskassigning.service.UserServiceConnectorDelegate;
import org.kie.kogito.taskassigning.service.event.UserDataEvent;
import org.kie.kogito.taskassigning.service.processing.AttributesProcessorRegistry;
import org.kie.kogito.taskassigning.service.util.IndexedElement;
import org.kie.kogito.taskassigning.service.util.TaskUtil;
import org.kie.kogito.taskassigning.service.util.TraceUtil;
import org.kie.kogito.taskassigning.service.util.UserUtil;
import org.optaplanner.core.api.solver.ProblemFactChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolutionChangesBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolutionChangesBuilder.class);
    private Map<String, User> usersById;
    private final List<AddTaskProblemFactChange> newTasksChanges = new ArrayList<AddTaskProblemFactChange>();
    private final List<RemoveTaskProblemFactChange> removedTaskChanges = new ArrayList<RemoveTaskProblemFactChange>();
    private final Set<TaskAssignment> removedTasksSet = new HashSet<TaskAssignment>();
    private final List<ReleaseTaskProblemFactChange> releasedTasksChanges = new ArrayList<ReleaseTaskProblemFactChange>();
    private final Map<String, List<IndexedElement<AssignTaskProblemFactChange>>> assignToUserChangesByUserId = new HashMap<String, List<IndexedElement<AssignTaskProblemFactChange>>>();
    private final List<TaskInfoChangeProblemFactChange> taskPropertyChanges = new ArrayList<TaskInfoChangeProblemFactChange>();
    private final List<AddUserProblemFactChange> newUserChanges = new ArrayList<AddUserProblemFactChange>();
    private final List<ProblemFactChange<TaskAssigningSolution>> updateUserChanges = new ArrayList<ProblemFactChange<TaskAssigningSolution>>();
    private final List<RemoveUserProblemFactChange> removableUserChanges = new ArrayList<RemoveUserProblemFactChange>();
    private final List<ProblemFactChange<TaskAssigningSolution>> totalChanges = new ArrayList<ProblemFactChange<TaskAssigningSolution>>();
    private TaskAssigningServiceContext context;
    private UserServiceConnectorDelegate userServiceConnector;
    private TaskAssigningSolution solution;
    private List<TaskData> taskDataList;
    private UserDataEvent userDataEvent;
    private AttributesProcessorRegistry processorRegistry;

    private SolutionChangesBuilder() {
    }

    public static SolutionChangesBuilder create() {
        return new SolutionChangesBuilder();
    }

    public SolutionChangesBuilder withContext(TaskAssigningServiceContext context) {
        this.context = context;
        return this;
    }

    public SolutionChangesBuilder withUserServiceConnector(UserServiceConnectorDelegate userServiceConnector) {
        this.userServiceConnector = userServiceConnector;
        return this;
    }

    public SolutionChangesBuilder withProcessors(AttributesProcessorRegistry processorRegistry) {
        this.processorRegistry = processorRegistry;
        return this;
    }

    public SolutionChangesBuilder forSolution(TaskAssigningSolution solution) {
        this.solution = solution;
        return this;
    }

    public SolutionChangesBuilder fromTasksData(List<TaskData> taskDataList) {
        this.taskDataList = taskDataList;
        return this;
    }

    public SolutionChangesBuilder fromUserDataEvent(UserDataEvent userDataEvent) {
        this.userDataEvent = userDataEvent;
        return this;
    }

    public List<ProblemFactChange<TaskAssigningSolution>> build() {
        this.usersById = this.solution.getUserList().stream().collect(Collectors.toMap(IdentifiableElement::getId, Function.identity()));
        Map taskAssignmentById = TaskHelper.filterNonDummyAssignments((List)this.solution.getTaskAssignmentList()).stream().collect(Collectors.toMap(IdentifiableElement::getId, Function.identity()));
        for (TaskData taskData : this.taskDataList) {
            TaskAssignment taskAssignment = (TaskAssignment)taskAssignmentById.remove(taskData.getId());
            if (taskAssignment == null) {
                this.addNewTaskChanges(taskData);
                continue;
            }
            this.addTaskChanges(taskAssignment, taskData);
        }
        for (TaskAssignment taskAssignment : this.removedTasksSet) {
            this.removedTaskChanges.add(new RemoveTaskProblemFactChange(taskAssignment));
        }
        if (this.userDataEvent != null) {
            this.addFullSyncUserChanges((List)this.userDataEvent.getData());
        } else {
            this.addRemovableUserChanges();
        }
        this.totalChanges.addAll(this.newUserChanges);
        this.totalChanges.addAll(this.removedTaskChanges);
        this.totalChanges.addAll(this.releasedTasksChanges);
        for (List list : this.assignToUserChangesByUserId.values()) {
            List assignTaskChanges = list.stream().map(IndexedElement::getElement).collect(Collectors.toList());
            this.totalChanges.addAll(assignTaskChanges);
        }
        this.totalChanges.addAll(this.taskPropertyChanges);
        this.totalChanges.addAll(this.updateUserChanges);
        this.totalChanges.addAll(this.newTasksChanges);
        this.totalChanges.addAll(this.removableUserChanges);
        this.traceChanges();
        if (!this.totalChanges.isEmpty()) {
            this.totalChanges.add(0, (ProblemFactChange<TaskAssigningSolution>)((ProblemFactChange)scoreDirector -> this.context.setCurrentChangeSetId(this.context.nextChangeSetId())));
        }
        return this.totalChanges;
    }

    private void addNewTaskChanges(TaskData taskData) {
        if (TaskState.READY.value().equals(taskData.getState())) {
            Task newTask = TaskUtil.fromTaskData(taskData);
            this.processorRegistry.applyAttributesProcessor(newTask, (Map<String, Object>)newTask.getAttributes());
            this.newTasksChanges.add(new AddTaskProblemFactChange(new TaskAssignment(newTask)));
            this.context.setTaskPublished(taskData.getId(), false);
        } else if (TaskState.RESERVED.value().equals(taskData.getState())) {
            Task newTask = TaskUtil.fromTaskData(taskData);
            this.processorRegistry.applyAttributesProcessor(newTask, (Map<String, Object>)newTask.getAttributes());
            User user = this.getUser(this.usersById.get(taskData.getActualOwner()), taskData.getActualOwner());
            AssignTaskProblemFactChange change = new AssignTaskProblemFactChange(new TaskAssignment(newTask), user, true);
            this.context.setTaskPublished(taskData.getId(), true);
            SolutionChangesBuilder.addChangeToUser(this.assignToUserChangesByUserId, change, user, -1, true);
        }
    }

    private static void addChangeToUser(Map<String, List<IndexedElement<AssignTaskProblemFactChange>>> changesByUserId, AssignTaskProblemFactChange change, User user, int index, boolean pinned) {
        List userChanges = changesByUserId.computeIfAbsent(user.getId(), key -> new ArrayList());
        IndexedElement.addInOrder(userChanges, new IndexedElement<AssignTaskProblemFactChange>(change, index, pinned));
    }

    private void addTaskChanges(TaskAssignment taskAssignment, TaskData taskData) {
        String taskState = taskData.getState();
        if (TaskState.READY.value().equals(taskState)) {
            this.context.setTaskPublished(taskData.getId(), false);
            this.releasedTasksChanges.add(new ReleaseTaskProblemFactChange(taskAssignment));
        } else if (TaskState.RESERVED.value().equals(taskState)) {
            this.context.setTaskPublished(taskData.getId(), true);
            if (!taskData.getActualOwner().equals(taskAssignment.getUser().getId()) || !taskAssignment.isPinned()) {
                User user = this.getUser(this.usersById.get(taskData.getActualOwner()), taskData.getActualOwner());
                AssignTaskProblemFactChange change = new AssignTaskProblemFactChange(taskAssignment, user, true);
                SolutionChangesBuilder.addChangeToUser(this.assignToUserChangesByUserId, change, user, -1, true);
            }
        } else if (TaskState.isTerminal(taskState)) {
            this.removedTasksSet.add(taskAssignment);
        }
        if (!this.removedTasksSet.contains(taskAssignment)) {
            Task updatedTask = TaskUtil.fromTaskData(taskData);
            if (!SolutionChangesBuilder.equalsByTaskInfoProperties(taskAssignment.getTask(), updatedTask)) {
                this.processorRegistry.applyAttributesProcessor(updatedTask, (Map<String, Object>)updatedTask.getAttributes());
            } else {
                updatedTask.setAttributes(taskAssignment.getTask().getAttributes());
            }
            this.taskPropertyChanges.add(new TaskInfoChangeProblemFactChange(taskAssignment, updatedTask));
        }
    }

    private User getUser(User existingUser, String userId) {
        User user;
        org.kie.kogito.taskassigning.user.service.User externalUser;
        if (existingUser != null) {
            return existingUser;
        }
        LOGGER.debug("User {} was not found in current solution, it'll we looked up in the external user system .", (Object)userId);
        try {
            externalUser = this.userServiceConnector.findUser(userId);
        }
        catch (Exception e) {
            throw new TaskAssigningException("An error was produced while querying user: " + userId + " in the external user system.", e);
        }
        if (externalUser != null) {
            user = UserUtil.fromExternalUser(externalUser, this.processorRegistry);
        } else {
            LOGGER.warn("User {} was not found in the external user system, it looks like it's a manual assignment from the kogito tasks administration to a non existing user. It'll be added to the solution to respect the assignment.", (Object)userId);
            user = new User(userId);
        }
        return user;
    }

    private void addFullSyncUserChanges(List<org.kie.kogito.taskassigning.user.service.User> externalUserList) {
        HashSet updatedUserIds = new HashSet();
        externalUserList.stream().filter(externalUser -> !ModelConstants.IS_PLANNING_USER.test(externalUser.getId())).map(externalUser -> UserUtil.fromExternalUser(externalUser, this.processorRegistry)).forEach(synchedUser -> {
            User previousUser = this.usersById.get(synchedUser.getId());
            updatedUserIds.add(synchedUser.getId());
            if (previousUser == null) {
                this.newUserChanges.add(new AddUserProblemFactChange(synchedUser));
            } else if (!SolutionChangesBuilder.equalsByProperties(previousUser, synchedUser)) {
                this.updateUserChanges.add((ProblemFactChange<TaskAssigningSolution>)new UserPropertyChangeProblemFactChange(previousUser, true, synchedUser.getAttributes(), synchedUser.getGroups()));
            }
        });
        this.usersById.values().stream().filter(previousUser -> !ModelConstants.IS_PLANNING_USER.test(previousUser.getId())).filter(previousUser -> !updatedUserIds.contains(previousUser.getId())).filter(User::isEnabled).forEach(previousUser -> this.updateUserChanges.add((ProblemFactChange<TaskAssigningSolution>)new DisableUserProblemFactChange(previousUser)));
    }

    private void addRemovableUserChanges() {
        this.solution.getUserList().stream().filter(user -> !ModelConstants.IS_PLANNING_USER.test(user.getId())).filter(user -> !user.isEnabled()).filter(user -> !this.assignToUserChangesByUserId.containsKey(user.getId())).filter(user -> !TaskHelper.hasPinnedTasks((ChainElement)user)).forEach(user -> this.removableUserChanges.add(new RemoveUserProblemFactChange(user)));
    }

    private static boolean equalsByProperties(User a, User b) {
        return Objects.equals(a.isEnabled(), b.isEnabled()) && Objects.equals(a.getGroups(), b.getGroups()) && Objects.equals(a.getAttributes(), b.getAttributes());
    }

    private static boolean equalsByTaskInfoProperties(Task a, Task b) {
        return Objects.equals(a.getDescription(), b.getDescription()) && Objects.equals(a.getPriority(), b.getPriority()) && Objects.equals(a.getPotentialUsers(), b.getPotentialUsers()) && Objects.equals(a.getPotentialGroups(), b.getPotentialGroups()) && Objects.equals(a.getExcludedUsers(), b.getExcludedUsers()) && Objects.equals(a.getAdminUsers(), b.getAdminUsers()) && Objects.equals(a.getAdminGroups(), b.getAdminGroups()) && Objects.equals(a.getInputData(), b.getInputData());
    }

    private void traceChanges() {
        if (LOGGER.isTraceEnabled()) {
            if (!this.totalChanges.isEmpty()) {
                TraceUtil.traceProgrammedChanges(LOGGER, this.removedTaskChanges, this.releasedTasksChanges, this.assignToUserChangesByUserId, this.taskPropertyChanges, this.newTasksChanges, this.newUserChanges, this.updateUserChanges, this.removableUserChanges);
            } else {
                LOGGER.trace("No changes has been calculated.");
            }
        }
    }
}

