/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service;

import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.kie.kogito.taskassigning.service.TaskAssigningException;
import org.kie.kogito.taskassigning.service.TaskData;
import org.kie.kogito.taskassigning.service.TaskServiceConnector;
import org.kie.kogito.taskassigning.service.TaskState;
import org.kie.kogito.taskassigning.service.util.TaskUtil;
import org.kie.kogito.taskassigning.user.service.User;
import org.kie.kogito.taskassigning.user.service.UserServiceConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class SolutionDataLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolutionDataLoader.class);
    private static final String SERVICE_ACCESS_ERROR = "An error was produced during solution data loading. It was not possible to access the %s, error: %s";
    private final TaskServiceConnector taskServiceConnector;
    private final UserServiceConnector userServiceConnector;

    @Inject
    public SolutionDataLoader(TaskServiceConnector taskServiceConnector, UserServiceConnector userServiceConnector) {
        this.taskServiceConnector = taskServiceConnector;
        this.userServiceConnector = userServiceConnector;
    }

    @Asynchronous
    @Retry(maxRetries=-1, delay=2000L, maxDuration=15L, durationUnit=ChronoUnit.MINUTES)
    @Timeout(value=10L, unit=ChronoUnit.MINUTES)
    public CompletionStage<Result> loadSolutionData(boolean includeTasks, boolean includeUsers, int pageSize) {
        CompletableFuture<Result> future = new CompletableFuture<Result>();
        try {
            Result result = this.loadData(includeTasks, includeUsers, pageSize);
            future.complete(result);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    private Result loadData(boolean includeTasks, boolean includeUsers, int pageSize) {
        List<TaskData> tasks = null;
        List users = null;
        try {
            if (includeTasks) {
                tasks = TaskUtil.fromUserTaskInstances(this.taskServiceConnector.findAllTasks(Arrays.asList(TaskState.READY.value(), TaskState.RESERVED.value()), pageSize));
            }
            if (includeUsers) {
                users = this.userServiceConnector.findAllUsers();
            }
            return new Result(tasks != null ? tasks : new ArrayList<TaskData>(), users != null ? users : new ArrayList());
        }
        catch (Exception e) {
            String msg = includeTasks && tasks == null ? String.format(SERVICE_ACCESS_ERROR, "Task Service", e.getMessage()) : String.format(SERVICE_ACCESS_ERROR, "User Service", e.getMessage());
            LOGGER.warn(msg);
            throw new TaskAssigningException(msg, e);
        }
    }

    public static class Result {
        private final List<TaskData> tasks;
        private final List<User> users;

        public Result(List<TaskData> tasks, List<User> users) {
            this.tasks = tasks;
            this.users = users;
        }

        public List<TaskData> getTasks() {
            return this.tasks;
        }

        public List<User> getUsers() {
            return this.users;
        }
    }
}

