/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service;

import java.util.List;
import org.kie.kogito.taskassigning.core.model.TaskAssigningSolution;
import org.kie.kogito.taskassigning.service.RunnableBase;
import org.optaplanner.core.api.solver.ProblemFactChange;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolverExecutor
extends RunnableBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolverExecutor.class);
    private Solver<TaskAssigningSolution> solver;
    private TaskAssigningSolution solution;
    private SolverFactory<TaskAssigningSolution> solverFactory;
    private SolverEventListener<TaskAssigningSolution> eventListener;

    public SolverExecutor(SolverFactory<TaskAssigningSolution> solverFactory, SolverEventListener<TaskAssigningSolution> eventListener) {
        this.solverFactory = solverFactory;
        this.eventListener = eventListener;
    }

    public void start(TaskAssigningSolution solution) {
        this.startCheck();
        this.solution = solution;
        try {
            this.solver = this.solverFactory.buildSolver();
        }
        catch (Exception e) {
            this.status.set(RunnableBase.Status.STOPPED);
            throw new SolverExecutorException(e.getMessage(), e);
        }
        this.solver.addEventListener(event -> {
            if (this.isAlive() && this.isStarted()) {
                this.eventListener.bestSolutionChanged(event);
            }
        });
        this.startPermit.release();
    }

    public boolean isStarted() {
        return this.status.get() == RunnableBase.Status.STARTED;
    }

    public boolean isStopped() {
        return this.status.get() == RunnableBase.Status.STOPPED;
    }

    public void stop() {
        if (!this.isDestroyed()) {
            RunnableBase.Status previousStatus = this.status.getAndSet(RunnableBase.Status.STOPPING);
            if (previousStatus == RunnableBase.Status.STARTED) {
                this.solver.terminateEarly();
            } else {
                this.status.set(RunnableBase.Status.STOPPED);
            }
        }
    }

    @Override
    public void destroy() {
        if (this.status.getAndSet(RunnableBase.Status.DESTROYED) == RunnableBase.Status.STARTED) {
            this.solver.terminateEarly();
        } else {
            this.startPermit.release();
        }
    }

    public void addProblemFactChanges(List<ProblemFactChange<TaskAssigningSolution>> changes) {
        if (!this.isStarted()) {
            throw new SolverExecutorException("SolverExecutor has not been started. Be sure it's started and not stopped or destroyed prior to executing this method");
        }
        this.solver.addProblemFactChanges(changes);
    }

    @Override
    public void run() {
        while (this.isAlive()) {
            try {
                LOGGER.debug("SolverExecutor is waiting for a start(solution) method invocation for starting the Solver.");
                this.startPermit.acquire();
                LOGGER.debug("SolverExecutor, the Solver will be started.");
                if (!this.isAlive() || !this.status.compareAndSet(RunnableBase.Status.STARTING, RunnableBase.Status.STARTED)) continue;
                this.solver.solve((Object)this.solution);
                if (this.isAlive()) {
                    this.status.set(RunnableBase.Status.STOPPED);
                    LOGGER.debug("Solver has been stopped. It can be restarted with the start(solution) method.");
                    continue;
                }
                LOGGER.debug("SolverExecutor has been destroyed. No more invocations can be done on this instance.");
            }
            catch (InterruptedException e) {
                super.destroy();
                Thread.currentThread().interrupt();
                if (this.solver != null && this.solver.isSolving()) {
                    this.solver.isTerminateEarly();
                }
                LOGGER.error("SolverExecutor was interrupted.", (Throwable)e);
            }
        }
        super.destroy();
        LOGGER.debug("SolverExecutor finished.");
    }

    public static class SolverExecutorException
    extends RuntimeException {
        public SolverExecutorException(String message) {
            super(message);
        }

        public SolverExecutorException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

