/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service.config;

import java.net.URL;
import java.time.Duration;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class TaskAssigningConfig {
    public static final String DEFAULT_USER_SERVICE_CONNECTOR = "PropertiesConnector";
    @Inject
    @ConfigProperty(name="kogito.task-assigning.oidc-client")
    Optional<String> oidcClient;
    @Inject
    @ConfigProperty(name="kogito.task-assigning.user")
    Optional<String> clientAuthUser;
    @Inject
    @ConfigProperty(name="kogito.task-assigning.password")
    Optional<String> clientAuthPassword;
    @Inject
    @ConfigProperty(name="kogito.task-assigning.data-index.server-url")
    URL dataIndexServerUrl;
    @Inject
    @ConfigProperty(name="kogito.task-assigning.data-index.connect-timeout-duration", defaultValue="PT30S")
    Duration dataIndexConnectTimeoutDuration;
    @Inject
    @ConfigProperty(name="kogito.task-assigning.data-index.read-timeout-duration", defaultValue="PT3M")
    Duration dataIndexReadTimeoutDuration;
    @Inject
    @ConfigProperty(name="org.kie.kogito.taskassigning.service.SolutionDataLoader/loadSolutionData/pageSize", defaultValue="3000")
    int dataLoaderPageSize;
    @Inject
    @ConfigProperty(name="kogito.task-assigning.publish-window-size", defaultValue="2")
    int publishWindowSize;
    @Inject
    @ConfigProperty(name="kogito.task-assigning.user-service-connector", defaultValue="PropertiesConnector")
    String userServiceConnector;
    @Inject
    @ConfigProperty(name="kogito.task-assigning.user-service-sync-interval", defaultValue="PT2H")
    Duration userServiceSyncInterval;
    @Inject
    @ConfigProperty(name="kogito.task-assigning.wait-for-improved-solution-duration", defaultValue="PT0S")
    Duration waitForImprovedSolutionDuration;
    @Inject
    @ConfigProperty(name="kogito.task-assigning.improve-solution-on-background-duration", defaultValue="PT1M")
    Duration improveSolutionOnBackgroundDuration;
    @Inject
    @ConfigProperty(name="kogito.task-assigning.process-runtime.connect-timeout-duration", defaultValue="PT30S")
    Duration processRuntimeConnectTimeoutDuration;
    @Inject
    @ConfigProperty(name="kogito.task-assigning.process-runtime.read-timeout-duration", defaultValue="PT1M")
    Duration processRuntimeReadTimeoutDuration;

    public Optional<String> getOidcClient() {
        return this.oidcClient;
    }

    public Optional<String> getClientAuthUser() {
        return this.clientAuthUser;
    }

    public Optional<String> getClientAuthPassword() {
        return this.clientAuthPassword;
    }

    public URL getDataIndexServerUrl() {
        return this.dataIndexServerUrl;
    }

    public Duration getDataIndexConnectTimeoutDuration() {
        return this.dataIndexConnectTimeoutDuration;
    }

    public Duration getDataIndexReadTimeoutDuration() {
        return this.dataIndexReadTimeoutDuration;
    }

    public boolean isOidcClientSet() {
        return this.oidcClient.isPresent();
    }

    public boolean isBasicAuthSet() {
        return !this.isOidcClientSet() && this.clientAuthUser.isPresent();
    }

    public int getDataLoaderPageSize() {
        return this.dataLoaderPageSize;
    }

    public int getPublishWindowSize() {
        return this.publishWindowSize;
    }

    public String getUserServiceConnector() {
        return this.userServiceConnector;
    }

    public Duration getUserServiceSyncInterval() {
        return this.userServiceSyncInterval;
    }

    public Duration getWaitForImprovedSolutionDuration() {
        return this.waitForImprovedSolutionDuration;
    }

    public Duration getImproveSolutionOnBackgroundDuration() {
        return this.improveSolutionOnBackgroundDuration;
    }

    public Duration getProcessRuntimeConnectTimeoutDuration() {
        return this.processRuntimeConnectTimeoutDuration;
    }

    public Duration getProcessRuntimeReadTimeoutDuration() {
        return this.processRuntimeReadTimeoutDuration;
    }

    public String toString() {
        return "TaskAssigningConfig{oidcClient=" + this.oidcClient + ", clientAuthUser=" + this.clientAuthUser + ", clientAuthPassword=" + (this.clientAuthPassword.isEmpty() ? null : "*****") + ", dataIndexServerUrl=" + this.dataIndexServerUrl + ", dataIndexConnectTimeoutDuration=" + this.dataIndexConnectTimeoutDuration + ", dataIndexReadTimeoutDuration=" + this.dataIndexReadTimeoutDuration + ", dataLoaderPageSize=" + this.dataLoaderPageSize + ", publishWindowSize=" + this.publishWindowSize + ", userServiceConnector=" + this.userServiceConnector + ", userServiceSyncInterval=" + this.userServiceSyncInterval + ", waitForImprovedSolutionDuration=" + this.waitForImprovedSolutionDuration + ", improveSolutionOnBackgroundDuration= " + this.improveSolutionOnBackgroundDuration + ", processRuntimeConnectTimeoutDuration=" + this.processRuntimeConnectTimeoutDuration + ", processRuntimeReadTimeoutDuration=" + this.processRuntimeReadTimeoutDuration + "}";
    }
}

