/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service.config;

import java.time.Duration;
import java.util.Optional;
import org.kie.kogito.taskassigning.service.config.TaskAssigningConfig;

public class TaskAssigningConfigValidator {
    private static final String PROPERTY_MUST_HAVE_NON_NEGATIVE_VALUE_ERROR = "The config property: %s must be set with a non negative value, but is: %s";
    private static final String PROPERTY_MUST_HAVE_VALUE_ERROR = "The config property: %s must be set with a value";
    private static final String PROPERTY_MUST_HAVE_NON_NEGATIVE_ZERO_OR_GREATER_THAN_ONE_MILLISECOND_VALUE_ERROR = "The config property: %s must be set with a zero or a greater or equal than one milliseconds duration, but is: %s";
    private TaskAssigningConfig config;

    private TaskAssigningConfigValidator(TaskAssigningConfig config) {
        this.config = config;
    }

    public static TaskAssigningConfigValidator of(TaskAssigningConfig config) {
        return new TaskAssigningConfigValidator(config);
    }

    public void validate() {
        TaskAssigningConfigValidator.validateDataIndexConfig(this.config);
        TaskAssigningConfigValidator.validateProcessRuntimeConfig(this.config);
        if (this.config.isBasicAuthSet()) {
            TaskAssigningConfigValidator.validateBasicAuth(this.config);
        }
        TaskAssigningConfigValidator.validateUserSyncConfig(this.config);
        TaskAssigningConfigValidator.validateWaitForImprovedSolutionDuration(this.config);
        TaskAssigningConfigValidator.validateImproveSolutionOnBackgroundDuration(this.config);
    }

    private static void validateBasicAuth(TaskAssigningConfig config) {
        TaskAssigningConfigValidator.validateOptionalIsSet("kogito.task-assigning.user", config.getClientAuthUser());
    }

    private static void validateOptionalIsSet(String propertyName, Optional<?> value) {
        if (value.isEmpty()) {
            throw new IllegalArgumentException(String.format(PROPERTY_MUST_HAVE_VALUE_ERROR, propertyName));
        }
    }

    private static void validateUserSyncConfig(TaskAssigningConfig config) {
        if (config.getUserServiceSyncInterval().isNegative()) {
            throw new IllegalArgumentException(String.format(PROPERTY_MUST_HAVE_NON_NEGATIVE_VALUE_ERROR, "kogito.task-assigning.user-service-sync-interval", config.getUserServiceSyncInterval()));
        }
    }

    private static void validateWaitForImprovedSolutionDuration(TaskAssigningConfig config) {
        TaskAssigningConfigValidator.validatePropertyIsZeroOrGreaterThanZeroMillisecondsDuration("kogito.task-assigning.wait-for-improved-solution-duration", config.getWaitForImprovedSolutionDuration());
    }

    private static void validateImproveSolutionOnBackgroundDuration(TaskAssigningConfig config) {
        TaskAssigningConfigValidator.validatePropertyIsZeroOrGreaterThanZeroMillisecondsDuration("kogito.task-assigning.improve-solution-on-background-duration", config.getImproveSolutionOnBackgroundDuration());
    }

    private static void validatePropertyIsZeroOrGreaterThanZeroMillisecondsDuration(String propertyName, Duration duration) {
        if (duration.isNegative() || !duration.isZero() && duration.toMillis() < 1L) {
            throw new IllegalArgumentException(String.format(PROPERTY_MUST_HAVE_NON_NEGATIVE_ZERO_OR_GREATER_THAN_ONE_MILLISECOND_VALUE_ERROR, propertyName, duration));
        }
    }

    private static void validateDataIndexConfig(TaskAssigningConfig config) {
        if (config.getDataIndexServerUrl() == null) {
            throw new IllegalArgumentException(String.format(PROPERTY_MUST_HAVE_VALUE_ERROR, "kogito.task-assigning.data-index.server-url"));
        }
        if (config.getDataIndexConnectTimeoutDuration().isNegative()) {
            throw new IllegalArgumentException(String.format(PROPERTY_MUST_HAVE_NON_NEGATIVE_VALUE_ERROR, "kogito.task-assigning.data-index.connect-timeout-duration", config.getDataIndexConnectTimeoutDuration()));
        }
        if (config.getDataIndexReadTimeoutDuration().isNegative()) {
            throw new IllegalArgumentException(String.format(PROPERTY_MUST_HAVE_NON_NEGATIVE_VALUE_ERROR, "kogito.task-assigning.data-index.read-timeout-duration", config.getDataIndexReadTimeoutDuration()));
        }
    }

    private static void validateProcessRuntimeConfig(TaskAssigningConfig config) {
        if (config.getProcessRuntimeConnectTimeoutDuration().isNegative()) {
            throw new IllegalArgumentException(String.format(PROPERTY_MUST_HAVE_NON_NEGATIVE_VALUE_ERROR, "kogito.task-assigning.process-runtime.connect-timeout-duration", config.getProcessRuntimeConnectTimeoutDuration()));
        }
        if (config.getProcessRuntimeReadTimeoutDuration().isNegative()) {
            throw new IllegalArgumentException(String.format(PROPERTY_MUST_HAVE_NON_NEGATIVE_VALUE_ERROR, "kogito.task-assigning.process-runtime.read-timeout-duration", config.getProcessRuntimeReadTimeoutDuration()));
        }
    }
}

