/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service.event;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import org.kie.kogito.taskassigning.service.event.DataEvent;
import org.kie.kogito.taskassigning.service.event.TaskAssigningServiceEventConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class BufferedTaskAssigningServiceEventConsumer
implements TaskAssigningServiceEventConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BufferedTaskAssigningServiceEventConsumer.class);
    private final List<DataEvent<?>> buffer = new ArrayList();
    private final AtomicBoolean paused = new AtomicBoolean(true);
    private Consumer<List<DataEvent<?>>> consumer;

    public void setConsumer(Consumer<List<DataEvent<?>>> consumer) {
        this.consumer = consumer;
    }

    @Override
    public synchronized void pause() {
        LOGGER.debug("pause was invoked with current buffer.size: {}", (Object)this.buffer.size());
        this.paused.set(true);
    }

    @Override
    public synchronized void resume() {
        LOGGER.debug("resume was invoked with current buffer.size: {}", (Object)this.buffer.size());
        this.paused.set(false);
        if (!this.buffer.isEmpty()) {
            this.deliverToConsumer();
        }
    }

    @Override
    public synchronized List<DataEvent<?>> pollEvents() {
        LOGGER.debug("pollEvents was invoked with current buffer.size: {}", (Object)this.buffer.size());
        ArrayList result = new ArrayList(this.buffer);
        this.buffer.clear();
        return result;
    }

    @Override
    public synchronized int queuedEvents() {
        return this.buffer.size();
    }

    @Override
    public synchronized void accept(DataEvent<?> dataEvent) {
        LOGGER.debug("Event {} being accepted, current buffer.size: {},  paused: {}", new Object[]{dataEvent.getDataEventType(), this.buffer.size(), this.paused.get()});
        this.buffer.add(dataEvent);
        if (!this.paused.get()) {
            LOGGER.debug("Delivering to consumer, current buffer.size: {}, paused: {}", (Object)this.buffer.size(), (Object)this.paused.get());
            this.deliverToConsumer();
        }
    }

    private void deliverToConsumer() {
        ArrayList result = new ArrayList(this.buffer);
        this.buffer.clear();
        this.consumer.accept(result);
    }
}

