/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service.health;

import java.time.format.DateTimeFormatter;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;
import org.kie.kogito.taskassigning.service.ServiceMessage;
import org.kie.kogito.taskassigning.service.ServiceStatus;
import org.kie.kogito.taskassigning.service.ServiceStatusInfo;
import org.kie.kogito.taskassigning.service.TaskAssigningService;

@ApplicationScoped
public class TaskAssigningServiceHealthCheck {
    public static final String SERVICE_STATUS = "service-status";
    public static final String SERVICE_STATUS_MESSAGE = "service-status-message";
    public static final String LIVENESS_NAME = "Task Assigning Service - liveness check";
    public static final String READINESS_NAME = "Task Assigning Service - readiness check";
    @Inject
    TaskAssigningService service;

    @Produces
    @Liveness
    HealthCheck livenessCheck() {
        return () -> {
            ServiceStatusInfo statusInfo = this.service.getContext().getStatusInfo();
            HealthCheckResponseBuilder builder = TaskAssigningServiceHealthCheck.newBuilder(LIVENESS_NAME, statusInfo);
            if (statusInfo.getStatus() == ServiceStatus.ERROR || statusInfo.getStatus() == ServiceStatus.SHUTDOWN) {
                return builder.down().build();
            }
            return builder.up().build();
        };
    }

    @Produces
    @Readiness
    HealthCheck readinessCheck() {
        return () -> {
            ServiceStatusInfo statusInfo = this.service.getContext().getStatusInfo();
            HealthCheckResponseBuilder builder = TaskAssigningServiceHealthCheck.newBuilder(READINESS_NAME, statusInfo);
            if (statusInfo.getStatus() == ServiceStatus.READY) {
                return builder.up().build();
            }
            return builder.down().build();
        };
    }

    private static HealthCheckResponseBuilder newBuilder(String name, ServiceStatusInfo statusInfo) {
        HealthCheckResponseBuilder builder = HealthCheckResponse.builder().name(name).withData(SERVICE_STATUS, statusInfo.getStatus().name());
        if (statusInfo.getStatusMessage() != null) {
            builder.withData(SERVICE_STATUS_MESSAGE, TaskAssigningServiceHealthCheck.buildServerMessage(statusInfo.getStatusMessage()));
        }
        return builder;
    }

    private static String buildServerMessage(ServiceMessage message) {
        return String.format("[%s]:[%s]:[%s]", message.getTime().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME), message.getType().name(), message.getValue());
    }
}

