/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service.processing;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.kie.kogito.taskassigning.core.model.Task;
import org.kie.kogito.taskassigning.model.processing.AttributesProcessor;
import org.kie.kogito.taskassigning.model.processing.TaskAttributesProcessor;
import org.kie.kogito.taskassigning.model.processing.TaskInfo;
import org.kie.kogito.taskassigning.model.processing.UserAttributesProcessor;
import org.kie.kogito.taskassigning.service.TaskAssigningException;
import org.kie.kogito.taskassigning.user.service.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class AttributesProcessorRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttributesProcessorRegistry.class);
    private final List<UserAttributesProcessor> userAttributesProcessors = new ArrayList<UserAttributesProcessor>();
    private final List<TaskAttributesProcessor> taskAttributesProcessors = new ArrayList<TaskAttributesProcessor>();

    @Inject
    public AttributesProcessorRegistry(Instance<AttributesProcessor<?>> processorsInstance) {
        for (AttributesProcessor processor : processorsInstance) {
            if (processor.isEnabled()) {
                if (processor instanceof UserAttributesProcessor) {
                    this.userAttributesProcessors.add((UserAttributesProcessor)processor);
                    continue;
                }
                if (processor instanceof TaskAttributesProcessor) {
                    this.taskAttributesProcessors.add((TaskAttributesProcessor)processor);
                    continue;
                }
                throw new IllegalArgumentException("Unexpected processor implementation: " + processor.getClass() + ", valid implementations must implement one of the following classes UserAttributesProcessor or TaskAttributesProcessor");
            }
            LOGGER.info("Attributes processor {} has been disabled.", processor.getClass());
        }
        this.userAttributesProcessors.sort(Comparator.comparingInt(AttributesProcessor::getPriority));
        this.taskAttributesProcessors.sort(Comparator.comparingInt(AttributesProcessor::getPriority));
    }

    public void applyAttributesProcessor(Task task, Map<String, Object> targetAttributes) {
        TaskInfo taskInfo = AttributesProcessorRegistry.wrapTask(task);
        for (TaskAttributesProcessor processor : this.taskAttributesProcessors) {
            try {
                processor.process((Object)taskInfo, targetAttributes);
            }
            catch (Exception e) {
                String msg = String.format("An error was produced during a task processor execution, processor class: %s, taskId: %s, processInstanceId: %s, processId: %s, error: %s", processor.getClass().getName(), taskInfo.getTaskId(), taskInfo.getProcessInstanceId(), taskInfo.getProcessId(), e.getMessage());
                throw new TaskAssigningException(msg);
            }
        }
    }

    public void applyAttributesProcessor(User user, Map<String, Object> targetAttributes) {
        for (UserAttributesProcessor processor : this.userAttributesProcessors) {
            try {
                processor.process((Object)user, targetAttributes);
            }
            catch (Exception e) {
                String msg = String.format("An error was produced during a user processor execution, processor class: %s, userId: %s, error: %s", processor.getClass().getName(), user.getId(), e.getMessage());
                throw new TaskAssigningException(msg);
            }
        }
    }

    private static TaskInfo wrapTask(final Task task) {
        return new TaskInfo(){

            public String getTaskId() {
                return task.getId();
            }

            public String getName() {
                return task.getName();
            }

            public String getDescription() {
                return task.getDescription();
            }

            public String getReferenceName() {
                return task.getReferenceName();
            }

            public String getPriority() {
                return task.getPriority();
            }

            public String getProcessInstanceId() {
                return task.getProcessInstanceId();
            }

            public String getProcessId() {
                return task.getProcessId();
            }

            public String getRootProcessInstanceId() {
                return task.getRootProcessInstanceId();
            }

            public String getRootProcessId() {
                return task.getRootProcessId();
            }

            public Set<String> getPotentialUsers() {
                return task.getPotentialUsers();
            }

            public Set<String> getPotentialGroups() {
                return task.getPotentialGroups();
            }

            public Set<String> getAdminUsers() {
                return task.getAdminUsers();
            }

            public Set<String> getAdminGroups() {
                return task.getAdminGroups();
            }

            public Set<String> getExcludedUsers() {
                return task.getExcludedUsers();
            }

            public ZonedDateTime getStarted() {
                return task.getStarted();
            }

            public Map<String, Object> getInputs() {
                return task.getInputData();
            }

            public String getEndpoint() {
                return task.getEndpoint();
            }
        };
    }
}

