/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Stream;
import org.kie.kogito.taskassigning.core.model.Group;
import org.kie.kogito.taskassigning.service.processing.AttributesProcessorRegistry;
import org.kie.kogito.taskassigning.user.service.User;

public class UserUtil {
    private UserUtil() {
    }

    public static org.kie.kogito.taskassigning.core.model.User fromExternalUser(User externalUser, AttributesProcessorRegistry processorRegistry) {
        org.kie.kogito.taskassigning.core.model.User user = new org.kie.kogito.taskassigning.core.model.User(externalUser.getId(), true);
        HashSet groups = new HashSet();
        user.setGroups(groups);
        if (externalUser.getGroups() != null) {
            externalUser.getGroups().forEach(externalGroup -> groups.add(new Group(externalGroup.getId())));
        }
        HashMap<String, Object> targetAttributes = new HashMap<String, Object>();
        if (externalUser.getAttributes() != null) {
            targetAttributes.putAll(externalUser.getAttributes());
        }
        processorRegistry.applyAttributesProcessor(externalUser, targetAttributes);
        user.setAttributes(targetAttributes);
        return user;
    }

    public static Stream<User> filterDuplicates(Collection<User> externalUsers) {
        if (externalUsers == null) {
            return Stream.empty();
        }
        HashSet included = new HashSet();
        return externalUsers.stream().filter(Objects::nonNull).filter(externalUser -> {
            if (!included.contains(externalUser.getId())) {
                included.add(externalUser.getId());
                return true;
            }
            return false;
        });
    }
}

