/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.taskassigning.core.model.ModelConstants;
import org.kie.kogito.taskassigning.core.model.TaskAssigningSolution;
import org.kie.kogito.taskassigning.core.model.TaskAssignment;
import org.kie.kogito.taskassigning.core.model.User;
import org.kie.kogito.taskassigning.service.PlanningBuilder;
import org.kie.kogito.taskassigning.service.PlanningItem;
import org.kie.kogito.taskassigning.service.TaskAssigningServiceContext;
import org.kie.kogito.taskassigning.service.TestUtil;

class PlanningBuilderTest {
    private static final String USER1 = "USER1";
    private static final String USER2 = "USER2";
    private static final String USER3 = "USER3";
    private static final String USER1_TASK1 = "USER1_TASK1";
    private static final String USER1_TASK2 = "USER1_TASK2";
    private static final String USER1_TASK3 = "USER1_TASK3";
    private static final String USER2_TASK1 = "USER2_TASK1";
    private static final String USER2_TASK2 = "USER2_TASK2";
    private static final String USER3_TASK1 = "USER3_TASK1";
    private static final String USER3_TASK2 = "USER3_TASK2";
    private static final String USER3_TASK3 = "USER3_TASK3";
    private static final String USER3_TASK4 = "USER3_TASK4";
    private static final String PLANNING_USER_TASK1 = "PLANNING_USER_TASK1";
    private static final String PLANNING_USER_TASK2 = "PLANNING_USER_TASK2";
    private static final String PLANNING_USER_TASK3 = "PLANNING_USER_TASK3";
    private static final String PLANNING_USER_TASK4 = "PLANNING_USER_TASK4";
    private static final String PLANNING_USER_TASK5 = "PLANNING_USER_TASK5";
    private TaskAssigningServiceContext context;

    PlanningBuilderTest() {
    }

    @Test
    void build() {
        this.context = new TaskAssigningServiceContext();
        List<TaskAssignment> user1Assignments = Arrays.asList(TestUtil.mockTaskAssignment(USER1_TASK1), TestUtil.mockTaskAssignment(ModelConstants.DUMMY_TASK_ASSIGNMENT.getId()), TestUtil.mockTaskAssignment(USER1_TASK2), TestUtil.mockTaskAssignment(USER1_TASK3));
        User user1 = TestUtil.mockUser(USER1, user1Assignments);
        List<TaskAssignment> user2Assignments = Arrays.asList(TestUtil.mockTaskAssignment(USER2_TASK1), TestUtil.mockTaskAssignment(USER2_TASK2));
        User user2 = TestUtil.mockUser(USER2, user2Assignments);
        List<TaskAssignment> user3Assignments = Arrays.asList(TestUtil.mockTaskAssignment(USER3_TASK1), TestUtil.mockTaskAssignment(USER3_TASK2), TestUtil.mockTaskAssignment(USER3_TASK3), TestUtil.mockTaskAssignment(USER3_TASK4));
        User user3 = TestUtil.mockUser(USER3, user3Assignments);
        List<TaskAssignment> planningUserAssignments = Arrays.asList(TestUtil.mockTaskAssignment(PLANNING_USER_TASK1), TestUtil.mockTaskAssignment(PLANNING_USER_TASK2), TestUtil.mockTaskAssignment(PLANNING_USER_TASK3), TestUtil.mockTaskAssignment(PLANNING_USER_TASK4), TestUtil.mockTaskAssignment(PLANNING_USER_TASK5));
        User planningUser = TestUtil.mockUser(ModelConstants.PLANNING_USER_ID, planningUserAssignments);
        ArrayList<TaskAssignment> allAssignments = new ArrayList<TaskAssignment>(user1Assignments);
        allAssignments.addAll(user2Assignments);
        allAssignments.addAll(user3Assignments);
        allAssignments.addAll(planningUserAssignments);
        List<User> allUsers = Arrays.asList(user1, user2, user3, planningUser);
        TaskAssigningSolution solution = new TaskAssigningSolution("1", allUsers, allAssignments);
        this.context.setTaskPublished(USER1_TASK1, false);
        this.context.setTaskPublished(ModelConstants.DUMMY_TASK_ASSIGNMENT.getId(), false);
        this.context.setTaskPublished(USER1_TASK2, false);
        this.context.setTaskPublished(USER1_TASK3, false);
        this.context.setTaskPublished(USER2_TASK1, true);
        this.context.setTaskPublished(USER2_TASK2, true);
        this.context.setTaskPublished(USER3_TASK1, false);
        this.context.setTaskPublished(USER3_TASK2, true);
        this.context.setTaskPublished(USER3_TASK3, true);
        this.context.setTaskPublished(USER3_TASK4, false);
        this.context.setTaskPublished(PLANNING_USER_TASK1, true);
        this.context.setTaskPublished(PLANNING_USER_TASK2, false);
        this.context.setTaskPublished(PLANNING_USER_TASK3, false);
        this.context.setTaskPublished(PLANNING_USER_TASK4, false);
        this.context.setTaskPublished(PLANNING_USER_TASK5, false);
        List planningItems = PlanningBuilder.create().withContext(this.context).withPublishWindowSize(2).forSolution(solution).build();
        ArrayList<TaskAssignment> expectedAssignmentsInPlanning = new ArrayList<TaskAssignment>();
        expectedAssignmentsInPlanning.add(user1Assignments.get(0));
        expectedAssignmentsInPlanning.add(user1Assignments.get(2));
        expectedAssignmentsInPlanning.add(user3Assignments.get(0));
        expectedAssignmentsInPlanning.add(planningUserAssignments.get(1));
        expectedAssignmentsInPlanning.add(planningUserAssignments.get(2));
        expectedAssignmentsInPlanning.add(planningUserAssignments.get(3));
        expectedAssignmentsInPlanning.add(planningUserAssignments.get(4));
        this.assertItemsForAssignments(planningItems, expectedAssignmentsInPlanning);
    }

    private void assertItemsForAssignments(List<PlanningItem> planningItems, List<TaskAssignment> taskAssignments) {
        Assertions.assertThat(planningItems).hasSize(taskAssignments.size());
        for (int i = 0; i < planningItems.size(); ++i) {
            PlanningItem planningItem = planningItems.get(i);
            TaskAssignment taskAssignment = taskAssignments.get(i);
            Assertions.assertThat((Object)planningItem.getTask()).isSameAs((Object)taskAssignment.getTask());
            Assertions.assertThat((String)planningItem.getTargetUser()).isEqualTo(taskAssignment.getUser().getId());
        }
    }
}

