/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.taskassigning.core.model.Task;
import org.kie.kogito.taskassigning.service.PlanningExecutionResultItem;
import org.kie.kogito.taskassigning.service.PlanningItem;

class PlanningExecutionResultItemTest {
    private PlanningItem planningItem;
    private Exception error;
    private PlanningExecutionResultItem resultItem;

    PlanningExecutionResultItemTest() {
    }

    @BeforeEach
    void setUp() {
        this.planningItem = new PlanningItem(Task.newBuilder().build(), "target_user");
        this.error = new Exception("some exception");
        this.resultItem = new PlanningExecutionResultItem(this.planningItem, this.error);
    }

    @Test
    void getItem() {
        Assertions.assertThat((Object)this.resultItem.getItem()).isSameAs((Object)this.planningItem);
    }

    @Test
    void getError() {
        Assertions.assertThat((Throwable)this.resultItem.getError()).isSameAs((Object)this.error);
    }

    @Test
    void hasErrorTrue() {
        Assertions.assertThat((boolean)this.resultItem.hasError()).isTrue();
    }

    @Test
    void hasErrorFalse() {
        this.resultItem = new PlanningExecutionResultItem(this.planningItem);
        Assertions.assertThat((boolean)this.resultItem.hasError()).isFalse();
    }
}

