/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.taskassigning.service;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.kie.kogito.taskassigning.ClientServices;
import org.kie.kogito.taskassigning.core.model.Task;
import org.kie.kogito.taskassigning.process.service.client.ProcessServiceClient;
import org.kie.kogito.taskassigning.service.PlanningExecutionResult;
import org.kie.kogito.taskassigning.service.PlanningExecutionResultItem;
import org.kie.kogito.taskassigning.service.PlanningExecutor;
import org.kie.kogito.taskassigning.service.PlanningItem;
import org.kie.kogito.taskassigning.service.RunnableBaseTest;
import org.kie.kogito.taskassigning.service.config.TaskAssigningConfig;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;

class PlanningExecutorTest
extends RunnableBaseTest<PlanningExecutor> {
    private static final String SERVICE1_URL = "http://service1.cloud.com:8280";
    private static final String PROCESS1_ID = "PROCESS1_ID";
    private static final String PROCESS1_INSTANCE_ID_1 = "PROCESS1_INSTANCE_ID_1";
    private static final String PROCESS1_INSTANCE_ID_2 = "PROCESS1_INSTANCE_ID_2";
    private static final String TASK1_NAME = "TASK1_NAME";
    private static final String TASK1_INSTANCE_ID_1 = "TASK1_INSTANCE_ID_1";
    private static final String TASK1_INSTANCE_ID_2 = "TASK1_INSTANCE_ID_2";
    private static final String SERVICE2_URL = "http://service2.cloud.com:8280";
    private static final String PROCESS2_ID = "PROCESS2_ID";
    private static final String PROCESS2_INSTANCE_ID_1 = "PROCESS2_INSTANCE_ID_1";
    private static final String TASK2_NAME = "TASK2_NAME";
    private static final String TASK2_INSTANCE_ID_1 = "TASK2_INSTANCE_ID_1";
    private static final String USER1 = "USER1";
    private static final String USER2 = "USER2";
    private static final String USER3 = "USER3";
    private static final String SERVICE_ERROR = "SERVICE_ERROR";
    @Mock
    private ClientServices clientServices;
    @Mock
    private TaskAssigningConfig config;
    private CountDownLatch resultApplied;
    @Captor
    private ArgumentCaptor<PlanningExecutionResult> resultCaptor;
    @Mock
    private Consumer<PlanningExecutionResult> resultConsumer;

    PlanningExecutorTest() {
    }

    @Override
    protected PlanningExecutor createRunnableBase() {
        return (PlanningExecutor)Mockito.spy((Object)((Object)new PlanningExecutorMock(this.clientServices, this.config)));
    }

    @Test
    @Timeout(value=5L)
    void start() throws Exception {
        CompletableFuture<Void> future = this.startRunnableBase();
        PlanningItem service1Item1 = new PlanningItem(PlanningExecutorTest.mockTask(SERVICE1_URL, PROCESS1_ID, PROCESS1_INSTANCE_ID_1, TASK1_NAME, TASK1_INSTANCE_ID_1), USER1);
        PlanningItem service1Item2 = new PlanningItem(PlanningExecutorTest.mockTask(SERVICE1_URL, PROCESS1_ID, PROCESS1_INSTANCE_ID_2, TASK1_NAME, TASK1_INSTANCE_ID_2), USER2);
        PlanningItem service2Item1 = new PlanningItem(PlanningExecutorTest.mockTask(SERVICE2_URL, PROCESS2_ID, PROCESS2_INSTANCE_ID_1, TASK2_NAME, TASK2_INSTANCE_ID_1), USER3);
        List<PlanningItem> planningItems = Arrays.asList(service1Item1, service1Item2, service2Item1);
        ProcessServiceClient service1Client = (ProcessServiceClient)Mockito.mock(ProcessServiceClient.class);
        ProcessServiceClient service2Client = (ProcessServiceClient)Mockito.mock(ProcessServiceClient.class);
        URL service1Url = new URL(SERVICE1_URL);
        URL service2Url = new URL(SERVICE2_URL);
        ((PlanningExecutor)Mockito.doReturn((Object)service1Client).when((Object)((PlanningExecutor)this.runnableBase))).createProcessServiceClient(this.clientServices, this.config, service1Url);
        ((PlanningExecutor)Mockito.doReturn((Object)service2Client).when((Object)((PlanningExecutor)this.runnableBase))).createProcessServiceClient(this.clientServices, this.config, service2Url);
        ((ProcessServiceClient)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException(SERVICE_ERROR)}).when((Object)service2Client)).transitionTask(PROCESS2_ID, PROCESS2_INSTANCE_ID_1, TASK2_NAME, TASK2_INSTANCE_ID_1, "claim", USER3, Collections.emptyList());
        this.resultApplied = new CountDownLatch(1);
        ((PlanningExecutor)this.runnableBase).start(planningItems, this.resultConsumer);
        this.resultApplied.await();
        ((PlanningExecutor)this.runnableBase).destroy();
        future.get();
        Assertions.assertThat((boolean)((PlanningExecutor)this.runnableBase).isDestroyed()).isTrue();
        ((PlanningExecutor)Mockito.verify((Object)((PlanningExecutor)this.runnableBase))).createProcessServiceClient(this.clientServices, this.config, service1Url);
        ((PlanningExecutor)Mockito.verify((Object)((PlanningExecutor)this.runnableBase))).createProcessServiceClient(this.clientServices, this.config, service2Url);
        ((Consumer)Mockito.verify(this.resultConsumer)).accept((PlanningExecutionResult)this.resultCaptor.capture());
        PlanningExecutionResult result = (PlanningExecutionResult)this.resultCaptor.getValue();
        Assertions.assertThat((Object)result).isNotNull();
        ((ListAssert)Assertions.assertThat((List)result.getItems()).isNotNull()).hasSize(3);
        this.assertSuccessfulInvocation((PlanningExecutionResultItem)result.getItems().get(0), service1Item1);
        this.assertSuccessfulInvocation((PlanningExecutionResultItem)result.getItems().get(1), service1Item2);
        this.assertUnSuccessfulInvocation((PlanningExecutionResultItem)result.getItems().get(2), service2Item1, SERVICE_ERROR);
        ((ProcessServiceClient)Mockito.verify((Object)service1Client)).close();
        ((ProcessServiceClient)Mockito.verify((Object)service2Client)).close();
    }

    private void assertSuccessfulInvocation(PlanningExecutionResultItem resultItem, PlanningItem expectedPlanningItem) {
        Assertions.assertThat((boolean)resultItem.hasError()).isFalse();
        Assertions.assertThat((Object)resultItem.getItem()).isSameAs((Object)expectedPlanningItem);
    }

    private void assertUnSuccessfulInvocation(PlanningExecutionResultItem resultItem, PlanningItem expectedPlanningItem, String expectedError) {
        Assertions.assertThat((boolean)resultItem.hasError()).isTrue();
        Assertions.assertThat((Object)resultItem.getItem()).isSameAs((Object)expectedPlanningItem);
        Assertions.assertThat((Throwable)resultItem.getError()).isNotNull();
        Assertions.assertThat((String)resultItem.getError().getMessage()).isEqualTo(expectedError);
    }

    private static Task mockTask(String serviceUrl, String processId, String processInstanceId, String taskName, String taskInstanceId) {
        return Task.newBuilder().processId(processId).processInstanceId(processInstanceId).name(taskName).id(taskInstanceId).endpoint(PlanningExecutorTest.buildEndpoint(serviceUrl, processId, processInstanceId, taskName, taskInstanceId)).build();
    }

    private static String buildEndpoint(String serviceUrl, String processId, String processInstanceId, String taskName, String taskInstanceId) {
        return serviceUrl + "/" + processId + "/" + processInstanceId + "/" + taskName + "/" + taskInstanceId;
    }

    private class PlanningExecutorMock
    extends PlanningExecutor {
        public PlanningExecutorMock(ClientServices clientServices, TaskAssigningConfig config) {
            super(clientServices, config);
        }

        void applyResult(PlanningExecutionResult result) {
            super.applyResult(result);
            PlanningExecutorTest.this.resultApplied.countDown();
        }
    }
}

